<?php

namespace App\Exports;

use App\Models\User;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ClientsExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    public function __construct()
    {}

    public function query()
    {
        return DB::table('clients')->select('id', 'client_name', 'client_phone', 'whatsapp_no', 'order_name', 'order_details', 'status', 'city', 'budget', 'notes')->orderByDesc('id');
        // return User::query()->select(['id','name','email','created_at'])->orderByDesc('id');
    }

    public function headings(): array
    {
        return ['ID', 'الاسم', 'رقم الهاتف', 'رقم الوتس اب', 'نوع الطلب', 'تفاصيل الطلب', 'حالة الطلب', 'المدينة', 'الميزانية', 'ملاحظات'];
    }

    public function map($client): array
    {
        return [
            $client->id,
            $client->client_name,
            $client->client_phone,
            $client->whatsapp_no,
            $client->order_name,
            $client->order_details,
            $client->status,
            $client->city,
            $client->budget,
            $client->notes,
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle('A1:D1')->getFont()->setBold(true);
        return [];
    }
}
