<?php

namespace App\Http\Controllers\Admin;

use App\Exports\ClientsExport;
use App\Imports\ClientsImport;
use App\Http\Controllers\Controller;
use App\Http\Repositories\Eloquent\Admin\ClientRepository;
use App\Http\Repositories\Eloquent\Admin\HomeRepository;
use App\Http\Requests\Admin\ClientRequests\StoreClientRequest;
use App\Models\Client;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class HomeController extends Controller
{
    public $home;
    public $clientRepository;

    public function __construct(HomeRepository $home, ClientRepository $clientRepository)
    {
        $this->home = $home;
        $this->clientRepository = $clientRepository;
    }

    public function home()
    {
        return $this->home->home();
    }

    public function storeClient(StoreClientRequest $request)
    {
        try {
            $this->clientRepository->store($request);
            flash()->success('Success');
            return back();
        } catch (\Exception $e) {
            dd($e);
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function targetCrud(Request $request)
    {
        // return $this->targetRepository->search($request);
    }
    
    public function exportClients()
    {
        $file = 'clients_' . now('Africa/Cairo')->format('Ymd_His') . '.xlsx';
        return Excel::download(new ClientsExport(), $file);
    }
    
    public function importClients(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls'
        ]);

        Excel::import(new ClientsImport(), $request->file('file'));

        flash()->success('تم استيراد العملاء بنجاح');
        return back();
    }

}
