<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\OfferRepository;
use App\Http\Requests\Admin\OfferRequests\OfferDetailsStoreRequest;
use App\Http\Requests\Admin\OfferRequests\OfferDetailsUpdateRequest;
use App\Http\Requests\Admin\OfferRequests\OfferStoreRequest;
use App\Http\Requests\Admin\OfferRequests\OfferUpdateRequest;
use Illuminate\Support\Facades\Validator;

class OfferController extends Controller
{

    public $offers;

    public function __construct(OfferRepository $offers)
    {
        $this->offers = $offers;
    }

    public function index($offset = 0, $limit = PAGINATION_COUNT)
    {
        try{
            $offers = $this->offers->index($offset, $limit);
            return view('admin.offers.index', compact('offers'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return view('admin.offers.create');
    }

    public function store(OfferStoreRequest $request)
    {
        try{
            $this->offers->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            // dd($e);
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        $offer = $this->offers->findOne($id);
        return view('admin.offers.update', compact('offer'));
    }

    public function details($id)
    {
        $offer = $this->offers->findOne($id);
        return view('admin.offers.details', compact('offer'));
    }

    public function update(OfferUpdateRequest $request, $id)
    {
        try{
            $this->offers->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function customUpdate(Request $request, $id)
    {
        
        $validator = Validator::make($request->all(), [
            'nears_from' => 'nullable|array',
            'nears_from.*' => 'required|string|max:255',

            'features' => 'nullable|array',
            'features.*' => 'required|string|max:255',

            'guarantees' => 'nullable|array',
            'guarantees.*.years' => 'required|string|max:255',
            'guarantees.*.content' => 'required|string|max:255',

            'media' => 'nullable|array',
            'media.*' => 'required|mimes:jpeg,png,jpg,gif,svg,webp,mp4,mov,avi,wmv,mkv|max:10240',

            'pro_info_offer_number' => 'nullable|string|max:255',
            'pro_info_status'       => 'nullable|in:متاح,محجوز,مباع',
            'pro_info_type'         => 'nullable|in:1,2,3,4',
            'pro_info_city'         => 'nullable|string|max:255',
            'pro_info_rooms_count'  => 'nullable|string|max:255',
            'pro_info_area'         => 'nullable|string|max:255',
        ]);
        if ($validator->fails()) {
            flash()->error($validator->errors()->first());
            return back();
        }
        try{
            return $this->offers->customUpdate($request, $id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function deleteImg(Request $request, $id)
    {
        try{
            return $this->offers->deleteImg($id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function deleteDetails(Request $request, $id)
    {
        try{
            return $this->offers->deleteDetails($id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function customDelete(Request $request, $id)
    {
        try{
            return $this->offers->customDelete($id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function storeDetails(OfferDetailsStoreRequest $request, $id)
    {
        try{
            return $this->offers->storeDetails($request, $id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function updateDetails(OfferDetailsUpdateRequest $request, $id)
    {
        try{
            return $this->offers->updateDetails($request, $id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->offers->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->offers->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->offers->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->offers->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->offers->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        $offers = $this->offers->archives($offset, $limit);
        return view('admin.offers.archives', compact('offers'));
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->offers->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->offers->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->offers->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->offers->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}