<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\PageRepository;
use App\Http\Requests\Admin\PageRequests\PageStoreRequest;
use App\Http\Requests\Admin\PageRequests\PageUpdateRequest;
use Illuminate\Support\Facades\Validator;

class PageController extends Controller
{

    public $pages;

    public function __construct(PageRepository $pages)
    {
        $this->pages = $pages;
    }

    public function screens($pageNo)
    {
        try{
            $page = $this->pages->screens($pageNo);
            switch ($pageNo) {
                case 1:
                    return view('admin.pages.home-screen', compact('page'));
                    break;
                
                case 2:
                    return view('admin.pages.realstate-screen', compact('page'));
                    break;
                
                case 4:
                    return view('admin.pages.services-screen', compact('page'));
                    break;
                
                default:
                    break;
            }
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function requests()
    {
        try{
            $requests_data = $this->pages->requests();
            return view('admin.pages.requests', compact('requests_data'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }
    
    public function contacts()
    {
        try{
            $contacts = $this->pages->contacts();
            return view('admin.pages.contacts', compact('contacts'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function index($offset, $limit)
    {
        try{
            $pages = $this->pages->index($offset, $limit);
            return view('admin.pages.index', compact('pages'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return view('admin.pages.create');
    }

    public function store(PageStoreRequest $request)
    {
        // dd($request->all());
        try{
            return $this->pages->store($request);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function servicesUpdate(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title'        => ['required','string','max:255'],
            'comment'      => ['required','string','max:1255'],
            'img'          => ['nullable','file','mimes:jpg,jpeg,png,webp,avif,svg','max:2048'],
        ]);
        if ($validator->fails()) {
            flash()->error($validator->errors()->first());
            return back();
        }
        // dd($request->all());
        try{
            return $this->pages->servicesUpdate($request, $id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function servicesDelete($id)
    {
        try{
            return $this->pages->servicesDelete($id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function removeRating($id)
    {
        try{
            return $this->pages->removeRating($id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function removePartners($id)
    {
        try{
            return $this->pages->removePartners($id);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        $page = $this->pages->findOne($id);
        return view('admin.pages.update', compact('page'));
    }

    public function update(PageUpdateRequest $request, $id)
    {
        try{
            $this->pages->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->pages->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->pages->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->pages->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->pages->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->pages->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        $pages = $this->pages->archives($offset, $limit);
        return view('admin.pages.archives', compact('pages'));
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->pages->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->pages->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->pages->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->pages->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}