<?php

namespace App\Http\Controllers\Website;

use App\Exports\ClientsExport;
use App\Http\Controllers\Controller;
use App\Http\ServicesLayer\ForJawalyServices\ForJawalyService;
use App\Models\Contact;
use App\Models\Page;
use App\Models\Offer;
use App\Models\Rating;
use App\Models\Partner;
use App\Models\RequestModel;
use App\Models\Value;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class HomeController extends Controller
{
    public $page;
    public $offer;
    public $rating;
    public $partner;
    public $value;
    public $forJawalyService;
    public function __construct(Offer $offer, Rating $rating, Partner $partner, Page $page, Value $value, ForJawalyService $forJawalyService)
    {
        $this->page = $page;
        $this->offer = $offer;
        $this->rating = $rating;
        $this->partner = $partner;
        $this->value = $value;
        $this->forJawalyService = $forJawalyService;
    }

    public function home()
    {
        $data = [];
        $data['page'] = $this->page->active()->unArchive()->where('id', 1)->first();
        $data['ratings'] = $this->rating->active()->unArchive()->limit(12)->get();
        $data['partners'] = $this->partner->active()->unArchive()->limit(12)->get();
        $data['exclusive'] = $this->offer->active()->unArchive()->exclusive()->limit(12)->get();
        $data['realestate'] = $this->offer->active()->unArchive()->realestate()->limit(12)->get();
        return view('website.home', compact('data'));
    }

    public function aboute()
    {
        $data = [];
        $data['page'] = $this->page->active()->unArchive()->where('id', 2)->with(['values'])->first();
        return view('website.aboute', compact('data'));
    }

    public function services()
    {
        $data = [];
        $data['page'] = $this->page->active()->unArchive()->where('id', 4)->with(['values'])->first();
        return view('website.services', compact('data'));
    }

    public function offers()
    {
        $data = [];
        $data['page'] = $this->page->active()->unArchive()->where('id', 1)->first();
        $data['realestate'] = $this->offer->active()->unArchive()->realestate()->limit(12)->get();
        return view('website.offers', compact('data'));
    }

    public function offerDetails($id)
    {
        $data = [];
        $data['page'] = $this->page->active()->unArchive()->where('id', 1)->first();
        $data['offer'] = $this->offer->active()->unArchive()->where('id', $id)->with(['details'])->first();
        return view('website.offer_details', compact('data'));
    }

    public function storeForm()
    {
        $data = [];
        $data['page'] = $this->page->active()->unArchive()->where('id', 1)->first();
        return view('website.request', compact('data'));
    }
    public function storeReuest(Request $request)
    {
        $validator = $request->validate([
            'purpose' => 'required|in:بيع,إيجار',
            'category' => 'required|in:سكني,تجاري',
            'ptype' => 'required|in:أرض,شقة,فيلا,دوبلكس,دور,محل,مكتب',
            'buy_budget' => 'nullable|numeric|min:0',
            'invest_budget' => 'nullable|numeric|min:0',
            'city' => 'required|string|max:100',
            'full_name' => 'required|string|max:150',
            'phone' => 'required|min:7',
            'ctype' => 'nullable|in:يبحث عن عقار,مستثمر',
            'agree' => 'accepted',
        ]);
        
        RequestModel::create([
            'ptype' => $request->ptype,
            'city' => $request->city,
            'phone' => $request->phone,
            'ctype' => $request->ctype,
            'agree' => $request->agree,
            'purpose' => $request->purpose,
            'category' => $request->category,
            'full_name' => $request->full_name,
            'buy_budget' => $request->buy_budget,
            'invest_budget' => $request->invest_budget,
        ]);

        try {
            $message = 'new request from: '.$request->full_name .', mobile no: '. $request->phone;
            $this->forJawalyService->sendSMS("+966591790101", $message);
        } catch (\Throwable $th) {}

        flash()->success('Success');
        return back();
    }

    public function contactUs()
    {
        return view('website.contact');
    }
    public function storeContact(Request $request)
    {
        $validator = $request->validate([
            'name'    => ['required','string','min:3','max:255'],
            'email'   => ['required','email','max:255'],
            'mobile'  => ['nullable','regex:/^\+?\d{8,15}$/'],
            'message' => ['nullable','string','max:5000'],
        ]);
        
        Contact::create([
            'name' => $request->name ?? null,
            'email' => $request->email ?? null,
            'mobile' => $request->mobile ?? null,
            'message' => $request->message ?? null,
        ]);
        
        try {
            $message = 'new contact from: '.$request->name .', mobile no: '. $request->mobile;
            $headers = [
                "Accept: application/json", "Content-Type: application/json"
            ];
            $data = [
                "messages" => [[
                    "text" => $message, "numbers" => ["+966591790101"], "sender" => 'TechPack'
                ]]
            ];
            $this->forJawalyService->sendSMS("+966591790101", $message);
        } catch (\Exception $ex) {
            dd($ex);
        }

        flash()->success('Success');
        return back();
    }

}
