<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Offer;
use App\Models\OfferDetail;
use DevxPackage\AbstractRepository;
use Illuminate\Support\Facades\DB;

class OfferRepository extends AbstractRepository
{

    protected $model;
    protected $offerDetail;

    public function __construct(Offer $model, OfferDetail $offerDetail)
    {
        $this->model = $model;
        $this->offerDetail = $offerDetail;
    }

    public function crudName(): string
    {
        return 'offers';
    }

    public function index($offset, $limit)
    {
        return $this->pagination($offset, $limit);
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create(){}

    public function edit($id){}

    public function archivesPage($offset, $limit){}

    public function customUpdate($request, $id)
    {
        $offer = $this->model->where('id', $id)->first();
        if ($offer) {
            $data = [];
            $request = $this->handle_request($request);
            if (isset($request['nears_from']) && count($request['nears_from']) > 0) {
                $data['nears_from'] = implode(',', $request['nears_from']);
            }
            if (isset($request['features']) && count($request['features']) > 0) {
                $data['features'] = implode(',', $request['features']);
            }
            if (isset($request['guarantees']) && count($request['guarantees']) > 0) {
                $data['guarantees'] = json_encode($request['guarantees']);
            }
            
            $data['pro_info_type'] = isset($request['pro_info_type']) ? $request['pro_info_type'] : null;
            $data['pro_info_city'] = isset($request['pro_info_city']) ? $request['pro_info_city'] : null;
            $data['pro_info_area'] = isset($request['pro_info_area']) ? $request['pro_info_area'] : null;
            $data['pro_info_status'] = isset($request['pro_info_status']) ? $request['pro_info_status'] : null;
            $data['pro_info_rooms_count'] = isset($request['pro_info_rooms_count']) ? $request['pro_info_rooms_count'] : null;
            $data['pro_info_offer_number'] = isset($request['pro_info_offer_number']) ? $request['pro_info_offer_number'] : null;
            $data['pro_info_region'] = isset($request['pro_info_region']) ? $request['pro_info_region'] : null;
            $data['pro_info_floor'] = isset($request['pro_info_floor']) ? $request['pro_info_floor'] : null;
            $data['pro_info_details'] = isset($request['pro_info_details']) ? $request['pro_info_details'] : null;
            
            if (isset($request['media']) && count($request['media']) > 0) {
                $imgs = []; 
                foreach ($request['media'] as $file) {
                    if (!$file == null) {
                        $file = uploadIamge($file, $this->crudName()); // function on helper file to upload file
                        $imgs [] = [
                            'img' => $file,
                            'offer_id' => $offer->id
                        ];
                    }
                }
                DB::table('offer_imgs')->insert($imgs);
            }
            $offer->update($data);
            flash()->success('Success');
            return back();
        }else {
            flash()->error('offer not found');
            return back();
        }
    }

    public function deleteImg($id)
    {
        DB::table('offer_imgs')->where('id', $id)->delete();
        flash()->success('Success');
        return back();
    }

    public function deleteDetails($id)
    {
        DB::table('offer_details')->where('id', $id)->delete();
        flash()->success('Success');
        return back();
    }

    public function customDelete($id)
    {
        DB::table('offers')->where('id', $id)->update(['deleted_at' => now()]);
        flash()->success('Success');
        return back();
    }

    public function storeDetails($request, $id)
    {
        $offer = $this->model->where('id', $id)->first();
        if ($offer) {
            $request = $this->handle_request($request);
            $this->offerDetail->create([
                'offer_number' => $request['offer_number'] ?? null,
                'offer_status' => $request['offer_status'] ?? null,
                'offer_type' => $request['offer_type'] ?? null,
                'rooms_count' => $request['rooms_count'] ?? null,
                'city' => $request['city'] ?? null,
                'front' => $request['front'] ?? null,
                'floor' => $request['floor'] ?? null,
                'price' => $request['price'] ?? null,
                'area' => $request['area'] ?? null,
                
                'offer_id' => $offer->id,
            ]);
    
            flash()->success('Success');
            return back();
        }else {
            flash()->error('offer not found');
            return back();
        }
    }

    public function updateDetails($request, $id)
    {
        $detail = $this->offerDetail->where('id', $id)->first();
        if ($detail) {
            $request = $this->handle_request($request);
            $detail->update([
                'offer_number' => $request['offer_number'] ?? null,
                'offer_status' => $request['offer_status'] ?? null,
                'offer_type' => $request['offer_type'] ?? null,
                'rooms_count' => $request['rooms_count'] ?? null,
                'city' => $request['city'] ?? null,
                'front' => $request['front'] ?? null,
                'floor' => $request['floor'] ?? null,
                'price' => $request['price'] ?? null,
                'area' => $request['area'] ?? null,
            ]);
    
            flash()->success('Success');
            return back();
        }else {
            flash()->error('offer not found');
            return back();
        }
    }

}