<?php

namespace App\Http\Requests\Admin\ClientRequests;

use Illuminate\Foundation\Http\FormRequest;

class StoreClientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'client_name'   => 'required|string|max:100',
            'client_phone'  => 'required|string|min:7|max:20',
            'whatsapp'      => 'nullable|string|min:7|max:20',
            'order_name'    => 'required|string|max:255',
            'order_details' => 'nullable|string|max:2000',
            'status'        => 'required|string|max:255',
            'file'          => 'required|image|max:2048',
        ];
    }
}
