<?php

namespace App\Http\Requests\Admin\OfferRequests;

use Illuminate\Foundation\Http\FormRequest;

class OfferDetailsUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = $this->route('id'); // get from route
        // $id = $this->request->get('user_id'); // get from in blade
        return [
            'offer_number' => 'required|string|max:255|unique:offer_details,offer_number,' . $id,
            'offer_status' => 'required|in:متاح,محجوز,مباع',
            // 'offer_type' => 'required|in:1,2,3,4',
            'rooms_count' => 'required|min:1',
            // 'city' => 'required|string|max:255',
            'area' => 'required|min:1',

            'front' => 'required|string|max:255',
            'price' => 'required|string|max:255',
            'floor' => 'required|string|max:255',
        ];
    }
}
