<?php

namespace App\Http\Requests\Admin\OfferRequests;

use Illuminate\Foundation\Http\FormRequest;

class OfferStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title'             => 'required|string|max:255|unique:offers,title',
            'rooms_count'       => 'required|min:1',
            'bathrooms_count'   => 'required|min:1',
            'area'              => 'required|min:1',
            'facade'             => 'nullable|string|max:255',
            'offer_type'        => 'required|in:1,2',
            'price'             => 'required|numeric|min:0',
            'city'              => 'required|string|max:255',
            'parking_count'     => 'nullable|min:0',
            'status'            => 'required|in:متاح,محجوز,مباع',
            'file'             => 'nullable|image|max:2048',
        ];
    }
}
