<?php

namespace App\Http\Requests\Admin\PageRequests;

use Illuminate\Foundation\Http\FormRequest;

class PageStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'page_id'               => ['required','exists:pages,id'],
            'title'                 => ['required','string','max:255'],
            'info'                  => ['nullable','string','max:1255'],
            'base_img'              => ['nullable','file','mimes:jpg,jpeg,png,webp,avif','max:4096'],
            'message_img'           => ['nullable','file','mimes:jpg,jpeg,png,webp,avif','max:4096'],
            'statistic_img'         => ['nullable','file','mimes:jpg,jpeg,png,webp,avif','max:4096'],
            
            'partner_logos'         => ['nullable','array'],
            'partner_logos.*'       => ['file','mimes:jpg,jpeg,png,webp,avif,svg','max:2048'],
            
            'ratings'               => ['nullable','array'],
            'ratings.*.title'       => ['required','string','max:255'],
            'ratings.*.comment'     => ['required','string','max:1255'],
            'ratings.*.rating_at'   => ['required','date'],
            'ratings.*.rating'      => ['required','max:5','min:1'],
            'ratings.*.img'         => ['file','mimes:jpg,jpeg,png,webp,avif,svg','max:2048'],
            
            'values'                => ['nullable','array'],
            'values.*.title'        => ['required','string','max:255'],
            'values.*.comment'      => ['required','string','max:1255'],
            'values.*.img'          => ['file','mimes:jpg,jpeg,png,webp,avif,svg','max:2048'],
        ];
    }
}
