<?php

namespace App\Http\ServicesLayer\ForJawalyServices;

use Illuminate\Support\Facades\Http;

class ForJawalyService
{
    public function sendSMS($phone, string $message)
    {
        try {
            $headers = [
                "Accept: application/json", "Content-Type: application/json"
            ];
            $data = [
                "messages" => [[
                    "text" => $message, "numbers" => [$phone], "sender" => 'TechPack'
                ]]
            ];
            $response = Http::withHeaders($headers)
            ->baseUrl(config("services.forjawaly.base_url"))
            ->withBasicAuth(config("services.forjawaly.key"), config("services.forjawaly.secret"))
            ->post('account/area/sms/send', $data);
        } catch (\Exception $ex) {}
        return $response->json();

    }
}
