<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;

class ClientsImport implements ToCollection, WithStartRow
{
    /**
     * @return int
     */
    public function startRow(): int
    {
        return 2;
    }

    /**
     * @param Collection $rows
     */
    public function collection(Collection $rows)
    {
        $data = [];

        foreach ($rows as $row) {
            $data[] = [
                'client_name' => $row[1] ?? null,
                'client_phone' => $row[2] ?? null,
                'whatsapp_no' => $row[3] ?? null,
                'order_name' => $row[4] ?? null,
                'order_details' => $row[5] ?? null,
                'status' => $row[6] ?? null,
                'city' => $row[7] ?? null,
                'budget' => $row[8] ?? null,
                'notes' => $row[9] ?? null,
            ];
        }
        DB::table('clients')->insert($data);
    }
}
