<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Offer extends Model
{
    protected $table = 'offers';
	protected $fillable = [
		'title',
		'type',
		'rooms_count',
		'bathrooms_count',
		'area',
		'facade',
		'offer_type',
		'offer_number',
		'price',
		'city',
		'parking_count',
		'status',
		'img',
		'nears_from',
		'features',
		'guarantees',
		'pro_info_offer_number',
		'pro_info_status',
		'pro_info_type',
		'pro_info_city',
		'pro_info_rooms_count',
		'pro_info_area',
		'pro_info_details',
		'pro_info_floor',
		'pro_info_region',
	];
    public $timestamps = true;

	public function scopeExclusive($query){
		return $query->where('offer_type', 1);
	}

	public function scopeRealestate($query){
		return $query->where('offer_type', 2);
	}

	public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'title' => '', 
			'type' => '', 
			'rooms_count' => '', 
			'bathrooms_count' => '', 
			'area' => '', 
			'facade' => '', 
			'offer_type' => '', 
			'offer_number' => '', 
			'price' => '', 
			'city' => '', 
			'parking_count' => '', 
			'status' => '', 
			'img' => '', 
			'nears_from' => '',
			'features' => '',
			'guarantees' => '',
			'media' => '',

			'pro_info_offer_number' => '',
			'pro_info_status' => '',
			'pro_info_type' => '',
			'pro_info_city' => '',
			'pro_info_rooms_count' => '',
			'pro_info_area' => '',
			'pro_info_details' => '',
			'pro_info_floor' => '',
			'pro_info_region' => '',
			
			'offer_status' => '',
			'front' => '',
			'floor' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return [];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function media()
	{
		return $this->hasMany(OfferImg::class, 'offer_id');	
	}

	public function details()
	{
		return $this->hasMany(OfferDetail::class, 'offer_id');	
	}
}