<?php

namespace App\Models;

use Doctrine\Inflector\Rules\Patterns;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    protected $table = 'pages';
	protected $fillable = [
		'title',
		'base_img',
		'info',
		'message_img',
		'statistic_img',
		'statistics',
		'page_no',
	];
    public $timestamps = true;

	public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'title' => '',
			'base_img' => '',
			'info' => '',
			'message_img' => '',
			'statistic_img' => '',
			'statistics' => '',
			'page_no' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return [];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function page_details()
	{
		return $this->hasMany(PageDetail::class, 'page_id');
	}

	public function partners()
	{
		return $this->hasMany(Partner::class, 'page_id');
	}

	public function ratings()
	{
		return $this->hasMany(Rating::class, 'page_id');
	}

	public function values()
	{
		return $this->hasMany(Value::class, 'page_id');
	}
}