<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->timestamps();

            $table->string('client_name', 100)->nullable();
            $table->string('client_phone', 20)->nullable();
            $table->string('whatsapp_no', 20)->nullable();
            $table->string('order_name', 255)->nullable();
            $table->string('status', 255)->nullable();
            $table->text('order_details')->nullable();
            $table->string('img', 255)->nullable();

            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clients');
    }
};
