<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('offer_details', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('offer_number', 255)->nullable();
            $table->string('offer_status', 255)->nullable();
            $table->string('offer_type', 255)->nullable();
            $table->string('city', 255)->nullable();
            $table->string('rooms_count', 255)->nullable();
            $table->string('area', 255)->nullable();
            $table->string('front', 255)->nullable();
            $table->string('price', 255)->nullable();
            $table->string('floor', 255)->nullable();
            $table->integer('offer_id')->nullable();
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('offer_details');
    }
};
