<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('offers', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('title', 255)->nullable();
            $table->string('type', 255)->nullable();
            $table->string('rooms_count', 255)->nullable();
            $table->string('bathrooms_count', 255)->nullable();
            $table->string('area', 255)->nullable();
            $table->string('facade', 255)->nullable();
            $table->string('offer_type', 255)->nullable();
            $table->string('offer_number', 255)->nullable();
            $table->decimal('price', 15, 2)->nullable();
            $table->string('city', 255)->nullable();
            $table->string('parking_count', 255)->nullable();
            $table->enum('status', ['متاح','مباع','مؤجر'])->default('متاح');
            $table->string('img', 255)->nullable();
            $table->string('nears_from', 1255)->nullable();
            $table->string('features', 1255)->nullable();
            $table->json('guarantees')->nullable();

            $table->string('pro_info_offer_number')->nullable();
            $table->string('pro_info_status', 255)->nullable();
            $table->string('pro_info_type', 255)->nullable(); 
            $table->string('pro_info_city', 255)->nullable();
            $table->string('pro_info_area', 255)->nullable();
            $table->string('pro_info_details', 255)->nullable();
            $table->string('pro_info_floor', 255)->nullable();
            $table->string('pro_info_region', 255)->nullable();
            $table->integer('pro_info_rooms_count')->nullable();

            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('offers');
    }
};
