<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('title', 255)->nullable();
            $table->string('base_img', 255)->nullable();
            $table->string('info', 1255)->nullable();
            $table->string('message_img', 255)->nullable();
            $table->string('statistic_img', 255)->nullable();
            $table->json('statistics')->nullable();
            $table->tinyInteger('page_no')->nullable()->comment('{ 1 => الرئيسيه },{ 2 => قيمنا },{ 3 => نوع المساكن العقاريه },{ 4 => خدمتنا }');
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pages');
    }
};
