<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('requests', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
                    
            $table->string('purpose', 255);
            $table->string('category', 255);
            $table->string('ptype', 255);
            $table->decimal('buy_budget', 15, 2)->nullable();
            $table->decimal('invest_budget', 15, 2)->nullable();
            $table->string('city');
            $table->string('full_name');
            $table->string('phone');
            $table->string('ctype', 255)->nullable();
            $table->boolean('agree')->default(1);

            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('requests');
    }
};
