const offers = document.querySelector("#offersCarousel");
const projects = document.querySelector("#projectsCarousel");
if (offers)
  new bootstrap.Carousel(offers, {
    interval: 5000,
    ride: "carousel",
    pause: "hover",
    touch: true,
  });
if (projects)
  new bootstrap.Carousel(projects, {
    interval: 5200,
    ride: "carousel",
    pause: "hover",
    touch: true,
  });

$(function () {
  const $nav = $(".navbar");
  const toggleShadow = () => {
    $(window).scrollTop() > 20
      ? $nav.addClass("shadow-sm")
      : $nav.removeClass("shadow-sm");
  };
  toggleShadow();
  $(window).on("scroll", toggleShadow);

  $(".rating").each(function () {
    const current = +($(this).data("value") || 0);
    $(this)
      .children("i")
      .each(function (i) {
        if (i < current) $(this).addClass("text-warning");
      });
    $(this)
      .on("mouseenter", "i", function () {
        const idx = $(this).index();
        $(this)
          .parent()
          .children("i")
          .each(function (i) {
            $(this).toggleClass("text-warning", i <= idx);
          });
      })
      .on("mouseleave", function () {
        $(this)
          .children("i")
          .each(function (i) {
            $(this).toggleClass("text-warning", i < current);
          });
      });
  });

  let partnersPaused = false;
  $(".partners-track")
    .on("mouseenter", function () {
      partnersPaused = true;
      $(this).find(".partners-row").css("animation-play-state", "paused");
    })
    .on("mouseleave", function () {
      partnersPaused = false;
      $(this).find(".partners-row").css("animation-play-state", "running");
    });
});
$(function () {
  $("#menuToggle").on("click", function () {
    $("#mobileMenu").slideToggle(180);
  });
});
$(function () {
  const $menu = $("#mobileMenu");
  const $backdrop = $("#backdrop");
  const $btn = $("#menuToggle");
  const OPEN = "open",
    SHOW = "show";

  function openMenu() {
    $menu.addClass(OPEN);
    $backdrop.addClass(SHOW);
    $("body").addClass("overflow-hidden");
  }
  function closeMenu() {
    $menu.removeClass(OPEN);
    $backdrop.removeClass(SHOW);
    $("body").removeClass("overflow-hidden");
  }
  function toggleMenu() {
    $menu.hasClass(OPEN) ? closeMenu() : openMenu();
  }

  $btn.on("click", function (e) {
    e.stopPropagation();
    toggleMenu();
  });

  $backdrop.on("click", closeMenu);

  $(document).on("click", function (e) {
    if (
      $menu.hasClass(OPEN) &&
      !$(e.target).closest("#mobileMenu, #menuToggle").length
    ) {
      closeMenu();
    }
  });

  $menu.on("click", "a", closeMenu);

  $(document).on("keydown", function (e) {
    if (e.key === "Escape" && $menu.hasClass(OPEN)) closeMenu();
  });

  $(window).on("resize", function () {
    if (window.innerWidth >= 768) closeMenu();
  });
});

