<!DOCTYPE html>
<html lang="ar" dir="rtl">

    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>تسجيل الدخول | المسكن</title>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;800&display=swap" rel="stylesheet">
        <style>
            :root {
                --card: #ffffff;
                --text: #111827;
                --primary: #253b80;
                --primary-600: #1e3270;
                --ring: #d6d8e5;
            }

            * {
                box-sizing: border-box
            }

            html, body {
                height: 100%
            }

            body {
                margin: 0;
                font-family: "Cairo", system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Segoe UI Emoji";
                color: var(--text);
                min-height: 100vh;
                height: 100%;
                background: #0f172a;
                background-image: linear-gradient(180deg, rgba(0, 0, 0, .25), rgba(0, 0, 0, .45)), url("{{ asset('admin/assets/WhatsApp Image 2025-09-12 at 16.11.36_716354fa.jpg') }}");
                background-size: cover;
                background-position: center;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .page {
                width: 100%;
                display: grid;
                grid-template-columns: 1.25fr 1fr;
                gap: 0;
                border-radius: 32px;
                overflow: hidden;
                min-height: 70vh;
            }

            @media (max-width: 1024px) {
                .page {
                    grid-template-columns: 1fr;
                    min-height: 80vh
                }
            }

            .auth-wrap {
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
                border-radius: inherit;
            }

            .auth-card {
                width: min(485px, 90vw);
                background: var(--card);
                border-radius: 24px;
                box-shadow: 0 14px 40px rgba(0, 0, 0, .18);
                padding: 28px 28px 35%;
                border: 1px solid #e9e9ef;
                margin-top: 19%;
            }

            .auth-head small {
                color: #6b7280
            }

            .auth-title {
                font-weight: 800;
                margin: 6px 0 0
            }

            label {
                display: block;
                font-size: 11px;
                color: #6b7280;
                margin: 10px 4px 2px
            }

            .control {
                position: relative
            }

            input[type=email], input[type=password] {
                width: 100%;
                font-family: inherit;
                font-size: 12px;
                padding: 10px 7px;
                border-radius: 16px;
                border: 1px solid var(--ring);
                outline: none;
                background: #fbfbfd;
                transition: box-shadow .2s ease, border-color .2s ease;
            }

            input:focus {
                border-color: var(--primary);
                box-shadow: 0 0 0 4px rgba(37, 59, 128, .15)
            }

            .hint {
                margin-top: 8px;
                color: #a0a3ad;
                display: flex;
                align-items: center;
                gap: 8px;
                font-size: 12px
            }

            .hint .dot {
                width: 6px;
                height: 6px;
                border-radius: 50%;
                background: #c5c7d1
            }

            .btn {
                width: 100%;
                margin-top: 14px;
                padding: 12px 16px;
                font-weight: 700;
                border: none;
                border-radius: 16px;
                background: var(--primary);
                color: white;
                cursor: pointer;
                transition: transform .04s ease, background .15s ease;
            }

            .btn:hover {
                background: var(--primary-600)
            }

            .btn:active {
                transform: translateY(1px)
            }

            .corner-caption {
                position: fixed;
                top: 10px;
                left: 14px;
                color: #f0f0f0;
                font-size: 13px;
                user-select: none
            }

            .ltr {
                direction: ltr
            }
            
            .logo-area {
                margin-top: 32%;
                text-align: center;
                padding-left: 29%;
            }
            .logo-png { 
                max-width: 35%;
            }
            .building-future {
                margin: 20px;
                color: white;
                font-size: 47px;
                line-height: 41px;
            }
            .sub-building-future {
                color: white;
                font-size: 27px;
            }

            @media (max-width: 600px) {
                body {
                    align-items: flex-start;
                    padding: max(12px, env(safe-area-inset-top)) max(12px, env(safe-area-inset-right)) max(16px, env(safe-area-inset-bottom)) max(12px, env(safe-area-inset-left));
                }

                .page {
                    min-height: calc(100vh - 28px);
                    padding: 0;
                    border-radius: 16px;
                    display: block;
                }

                .auth-wrap {
                    padding: 0;
                }

                .auth-card {
                    width: 92vw;
                    max-width: 480px;
                    margin: 8vh auto 0;
                    padding: 18px 14px;
                    border-radius: 18px;
                    box-shadow: 0 10px 28px rgba(0, 0, 0, .25);
                }

                .auth-head {
                    margin-bottom: 8px
                }

                .auth-head small {
                    font-size: 12px
                }

                .auth-title {
                    font-size: 22px;
                    text-align: center;
                    margin: 6px 0 10px;
                }

                label {
                    font-size: 12px;
                    margin: 8px 4px 6px
                }

                .control {
                    margin-bottom: 6px
                }

                input[type=email], input[type=password] {
                    font-size: 14px;
                    padding: 12px 12px;
                    border-radius: 14px;
                }

                .hint {
                    font-size: 11px;
                    opacity: .9;
                    margin: 6px 0 10px;
                }

                .btn {
                    padding: 12px;
                    font-size: 14px;
                    border-radius: 14px;
                }

                .logo-area {
                    margin-top: 20%;
                    padding-left: 0px;
                }
                .building-future {
                    font-size: 37px;
                }
                .sub-building-future {
                    font-size: 22px;
                }
                /* .page {
                    display: flex;
                    flex-direction: column;
                }
                .page > .col-xs-12:first-child {
                    order: 2;
                }
                .page > .col-xs-12:last-child {
                    order: 1;
                }  */
            }

            @media (min-width: 601px) and (max-width: 1024px) {
                .page {
                    min-height: 85vh;
                    padding: 24px
                }

                .auth-card {
                    width: min(520px, 92vw);
                    margin: 6vh auto 0;
                    padding: 24px 20px;
                    border-radius: 22px
                }

                .auth-title {
                    font-size: 22px
                }

                input[type=email], input[type=password] {
                    font-size: 14px;
                    padding: 12px
                }

                .logo-area {
                    margin-top: 20%;
                    padding-left: 0px;
                }
                .building-future {
                    font-size: 37px;
                }
                .sub-building-future {
                    font-size: 22px;
                }
                /* .page {
                    display: flex;
                    flex-direction: column;
                }
                .page > .col-xs-12:first-child {
                    order: 2;
                }
                .page > .col-xs-12:last-child {
                    order: 1;
                } */
            }
        </style>
    </head>

    <body>
        <main class="page">
            <div class="col-xs-12 col-md-6">
                <section class="auth-wrap">
                    <form role="form" method="POST" class="auth-card" action="{{ url(route('admin/check-login')) }}">

                        @csrf
                        <div class="auth-head">
                            <small>أدخل بياناتك للدخول</small>
                            <h3 class="auth-title">تسجيل الدخول</h3>
                            @include('flash::message')
                            @if (isset($errors) && $errors->any())
                                <div style="text-align: left; margin: 15px;">
                                    <ul dir="ltr">
                                        @foreach ($errors->all() as $error)
                                            <li class="text-danger">{{$error}}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                        </div>

                        <label for="email">البريد</label>
                        <div class="control">
                            <input class="ltr" id="email" name="email" type="email" placeholder="johnsondoe@mail.com" required>
                        </div>

                        <label for="password">الـكلمة السرية</label>
                        <div class="control">
                            <input class="ltr" id="password" type="password" name="password" placeholder="••••••••••" required>
                        </div>

                        <div class="hint"><span class="dot"></span> سيتم الحفاظ على خصوصية بياناتك</div>
                        <button class="btn" type="submit">تسجيل الدخول</button>
                    </form>
                </section>
            </div>
            <div class="col-xs-12 col-md-6">
                <div class="logo-area">
                    <img class="logo-png" src="{{ asset('admin/assets/logo.png') }}" alt="صورة المستخدم" />
                    <div class="building-future-area" dir="rtl">
                        <p class="building-future" dir="ltr">
                            Building the Future...
                            <br>
                            <span class="sub-building-future">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</span>
                        </p>
                    </div>
                </div>
            </div>
        </main>

        <!-- footer -->
        {{-- <footer class="footer">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="text-center">
                            <p class="mb-0 text-muted">&copy;
                                <script> document.write(new Date().getFullYear()) </script> Crafted with <i class="mdi mdi-heart text-danger"></i> by AmrHussien
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </footer> --}}
    </body>

</html>
