@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>DashBoard</title>
@endsection

<!-- custom page -->
@section('css')
<style>
.add-client-modal .modal-dialog{
    max-width: 720px;
    width: calc(100% - 2rem);
    margin-inline: auto;
}
.add-client-modal .modal-body{
    max-height: 70vh;
    overflow: auto;
}
.add-client-modal .uploader-ui {
    max-height: 320px;
    overflow: hidden;
    border-radius: 12px;
}
.add-client-modal .uploader-preview {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
}
.pagination {
    list-style: none;
    display: flex;
    gap: 5px;
}
.page-item {
    list-style: none;
}
.page-link {
    text-decoration: none;
}
.custom-page-link {
    border-radius: 6px;
    padding: 0px 6px;
    border: 2px solid darkgray;
}
.custom-color-page-link {
    background: darkgray;
}
.requests-page-row{
    display:grid;
    grid-template-columns: repeat(9, minmax(120px,1fr));
    gap: 12px;
}

/* Flash Messages Styles */
.alert {
    padding: 15px 20px;
    border-radius: 8px;
    margin: 15px auto;
    max-width: 600px;
    font-weight: 500;
    text-align: center;
}
.alert-success {
    background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
    border: 1px solid #28a745;
    color: #155724;
}
.alert-danger, .alert-error {
    background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
    border: 1px solid #dc3545;
    color: #721c24;
}
.alert-warning {
    background: linear-gradient(135deg, #fff3cd 0%, #ffeeba 100%);
    border: 1px solid #ffc107;
    color: #856404;
}
.alert-info {
    background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%);
    border: 1px solid #17a2b8;
    color: #0c5460;
}
.error-area ul {
    background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
    border: 1px solid #dc3545;
    border-radius: 8px;
    padding: 15px 30px;
    max-width: 600px;
    margin: 15px auto;
}

</style>
@endsection

@section('content')

    <main class="main">
        <div class="topbar">
            <span class="crumb">لوحة التحكم</span>
            <div class="tools">
                <div class="tool">🔍</div>
                <div class="tool">⚙️</div>
            </div>
        </div>

        <!-- Overview: stats + banner -->
        <section class="overview" aria-label="ملخص علوي">
            <div class="stat">
                <span class="tag">الاجمالي</span>
                <div class="value">؋ 34.1K</div>
                <div class="delta">↑ 105.28%</div>
            </div>
            <div class="stat">
                <span class="tag">المصاريف</span>
                <div class="value">؋ 34.1K</div>
                <div class="delta">↑ 105.28%</div>
            </div>
            <div class="stat">
                <span class="tag">الارباح</span>
                <div class="value">؋ 3.1K</div>
                <div class="delta">↑ 105.28%</div>
            </div>
            <div class="banner">
                <div class="panel">
                    <img class="house-img" src="{{ asset('admin/assets/home-png 1.png') }}" alt="منزل حديث" />
                    <div>
                        <h3>استمتع ببيع منزلك</h3>
                        <p>الأول</p>
                    </div>
                </div>
            </div>
        </section>
        
        <div class="error-area" style="text-align: center;">
            @include('flash::message')
            @if ($errors->any())
                <div style="text-align: left; margin: 15px; color: red;">
                    <ul dir="ltr">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>

        <!-- Table Card -->
        <section class="card">
            <div class="card-header" dir="rtl">
                <h3>تقارير المبيعات</h3>
                <div style="display:flex; gap:8px">
                    <a href="{{ url(route('admin/export/clients')) }}" class="btn">تصدير</a>
                    <!-- <button class="btn primary">إضافة عميل +</button> -->
                    <button class="btn-add" id="openCustomerModalImport" type="button" aria-haspopup="dialog" aria-controls="customerModal">
                        استيراد عملاء
                    </button>
                    <button class="btn-add" id="openCustomerModal" type="button" aria-haspopup="dialog" aria-controls="customerModal">
                        <span class="plus">+</span> إضافة عميل
                    </button>
                    <!-- ========= Modal ========= -->
                    <div class="modal" id="importModal" role="dialog" aria-modal="true" aria-labelledby="importModalTitle" hidden>
                        <div class="modal__backdrop" data-close="true"></div>

                        <div class="modal__card" role="document">
                            <div class="modal__header">
                                <h3 class="modal__title" id="importModalTitle">استيراد عملاء</h3>
                                <button class="modal__close" type="button" aria-label="إغلاق" data-close="true">×</button>
                            </div>

                            <form class="modal__form" id="importForm" action="{{ url(route('admin/import/clients')) }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <label class="field">
                                    <div>
                                        <label class="home-form__upload">
                                            <span class="home-form__upload-text">رفع الملف</span>
                                            <input type="file" name="file" accept="image/*">
                                            <img class="upload__img" class="uploader-preview" src="" style="max-height:300px;width:100%;object-fit:cover;border-radius:12px">
                                        </label>
                                    </div>
                                </label>
                                <br/>
                                <label class="field">
                                    <span class="field__label"></span>
                                    <button class="btn-primary" type="submit">ارسال</button>
                                </label>
                            </form>
                        </div>
                    </div>
                    <div class="modal" id="customerModal" role="dialog" aria-modal="true"
                        aria-labelledby="customerModalTitle" hidden>
                        <div class="modal__backdrop" data-close="true"></div>

                        <div class="modal__card" role="document">
                            <div class="modal__header">
                                <h3 class="modal__title" id="customerModalTitle">إضافة عميل جديد</h3>
                                <button class="modal__close" type="button" aria-label="إغلاق" data-close="true">×</button>
                            </div>

                            <form class="modal__form" id="customerForm" action="{{ url(route('admin/store/client')) }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <label class="field">
                                    <span class="field__label">اسم العميل</span>
                                    <input name="client_name" class="field__input" type="text" placeholder="نورة" />
                                </label>
                                <label class="field">
                                    <span class="field__label">رقم العميل</span>
                                    <input name="client_phone" class="field__input" type="number" placeholder="545484455" />
                                </label>
                                <label class="field">
                                    <span class="field__label">رقم الواتس اب</span>
                                    <input name="whatsapp_no" class="field__input" type="number" placeholder="545654899" />
                                </label>
                                <label class="field">
                                    <span class="field__label">اسم الطلب</span>
                                    <input name="order_name" class="field__input" type="text" placeholder="حي علي محمد : جدة" />
                                </label>
                                <label class="field">
                                    <span class="field__label">تفاصيل الطلب</span>
                                    <input name="order_details" class="field__input" type="text" placeholder="شراء" />
                                </label>
                                <label class="field">
                                    <span class="field__label">حالة الطلب</span>
                                    <input name="status" class="field__input" type="text" placeholder="جاد" />
                                </label>
                                <label class="field">
                                    <div>
                                        <label class="home-form__upload">
                                            <span class="home-form__upload-text">رفع الصورة</span>
                                            <input type="file" name="file" accept="image/*">
                                            <img class="upload__img" class="uploader-preview" src="" style="max-height:300px;width:100%;object-fit:cover;border-radius:12px">
                                        </label>
                                    </div>
                                </label>
                                <br/>
                                <label class="field">
                                    <span class="field__label"></span>
                                    <button class="btn-primary" type="submit">حفظ التغييرات</button>
                                </label>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
            <div class="card-body">
                <table>
                    <thead>
                        <tr>
                            <th>رقم العميل</th>
                            <th>رقم الواتس اب</th>
                            <th>حالة الطلب</th>
                            <th>تفاصيل الطلب</th>
                            <th>اسم الطلب</th>
                            <th>اسم العميل</th>
                        </tr>
                    </thead>
                    <tbody>
                        @isset($clients)
                            @foreach($clients as $client)
                            {{-- ''   => 'required|string|max:100',
                            ''  => 'required|string|min:7|max:20',
                            'whatsapp'      => 'nullable|string|min:7|max:20',
                            ''    => 'required|string|max:255',
                            '' => 'nullable|string|max:2000',
                            ''        => 'required|string|max:255',
                            'file'          => 'required|image|max:2048', --}}
                                <tr>
                                    <td class="muted">{{ $client->client_phone }}</td>
                                    <td class="muted">{{ $client->whatsapp_no }}</td>
                                    <td>
                                        <div class="status"><span class="dot"></span> {{ $client->status }}</div>
                                    </td>
                                    <td style="color:var(--success);font-weight:700">{{ $client->order_details }}</td>
                                    <td class="muted">{{ $client->order_name }}</td>
                                    <td>
                                        <div class="agent">
                                            <span>{{ $client->client_name }}</span>
                                            <img src="{{ asset($client->img) }}" alt="نورة">
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @endisset
                    </tbody>
                </table>
                <div class="d-flex justify-content-center mt-2">
                    <div class="d-flex justify-content-center mt-2">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <!-- Previous Button -->
                                @if (!$clients->onFirstPage())
                                    <li class="page-item">
                                        <a class="page-link" href="{{ $clients->previousPageUrl() }}" aria-label="Previous">
                                            <span aria-hidden="true">&laquo;</span>
                                        </a>
                                    </li>
                                @endif

                                <!-- Pagination Numbers -->
                                @for ($i = 1; $i <= $clients->lastPage(); $i++)
                                    <li class="page-item {{ $i == $clients->currentPage() ? 'active' : '' }}">
                                        <a class="page-link custom-page-link {{ request()->get('page') == $i ? 'custom-color-page-link' : '' }}" href="{{ $clients->url($i) }}">
                                            {{ $i }}
                                        </a>
                                    </li>
                                @endfor

                                <!-- Next Button -->
                                @if ($clients->hasMorePages())
                                    <li class="page-item">
                                        <a class="page-link {{ request()->get('page') == $i ? 'custom-color-page-link' : '' }}" href="{{ $clients->nextPageUrl() }}" aria-label="Next">
                                            <span aria-hidden="true">&raquo;</span>
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </section>
    </main>

@endsection
<!-- custom js -->
@section('script')
  <script>
    (function () {
        $("#dashborad").addClass('active');

        // Customer Modal
        const openBtn = document.getElementById('openCustomerModal');
        const modal = document.getElementById('customerModal');
        const closeEls = modal.querySelectorAll('[data-close="true"]');
        const firstInput = () => modal.querySelector('.field__input');

        const open = () => {
            modal.hidden = false;
            setTimeout(() => firstInput()?.focus(), 10);
            document.addEventListener('keydown', onEsc);
        };
        const close = () => {
            modal.hidden = true;
            openBtn.focus();
            document.removeEventListener('keydown', onEsc);
        };
        const onEsc = (e) => { if (e.key === 'Escape') close(); };

        openBtn.addEventListener('click', open);
        closeEls.forEach(el => el.addEventListener('click', close));
        modal.addEventListener('click', (e) => { if (e.target.dataset.close === 'true') close(); });

        // Import Modal
        const openImportBtn = document.getElementById('openCustomerModalImport');
        const importModal = document.getElementById('importModal');
        const closeImportEls = importModal.querySelectorAll('[data-close="true"]');

        const openImport = () => {
            importModal.hidden = false;
            document.addEventListener('keydown', onEscImport);
        };
        const closeImport = () => {
            importModal.hidden = true;
            openImportBtn.focus();
            document.removeEventListener('keydown', onEscImport);
        };
        const onEscImport = (e) => { if (e.key === 'Escape') closeImport(); };

        openImportBtn.addEventListener('click', openImport);
        closeImportEls.forEach(el => el.addEventListener('click', closeImport));
        importModal.addEventListener('click', (e) => { if (e.target.dataset.close === 'true') closeImport(); });

        const btn = document.getElementById('togglePages');
        const list = document.getElementById('pagesList');
        const caret = document.getElementById('caret');
        btn?.addEventListener('click',()=>{
            const open = list.classList.toggle('open');
            caret.textContent = open ? '▾' : '▸';
        });

        // document.getElementById('customerForm').addEventListener('submit', (e) => {
        //     e.preventDefault();
        //     // close();
        // });
        document.addEventListener('change', function(e) {
            
            const t = e.target;
            if (!(t instanceof HTMLInputElement)) return;
            if (t.type !== 'file') return;

            if (t.name === 'file' || t.name === 'statistic_img') {
                return previewSingle(t);
            }

        });
        function previewSingle(input) {
            const file = input.files && input.files[0];
            const box = input.closest('label')
            if (!file || !box) return;
            let img = box.querySelector('.upload__img');
            if (!img) {
                img = document.createElement('img');
                img.className = 'upload__img';
                box.appendChild(img);
            }
            img.src = URL.createObjectURL(file);
            box.classList.add('has-image');
        }
    })();
  </script>
@endsection
