@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>Offers</title>
@endsection

<!-- custom css -->
@section('css')
@endsection

@section('content')
    <section class="offers-page" lang="ar" dir="rtl" aria-labelledby="offers-page-title">
        <header class="offers-page-topbar">
            <h2 id="offers-page-title" class="offers-page-title">العروض العقارية</h2>
        </header>
        @include('flash::message')
        @if ($errors->any())
            <div style="text-align: left; margin: 15px;">
                <ul dir="ltr">
                    @foreach ($errors->all() as $error)
                        <li class="text-danger">{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <header class="offers-page-topbar" dir="ltr">
            <button id="" class="offers-page-btn offers-page-btn--primary" type="button">
                <a href="{{ route('admin/offers/create') }}" class="custom-link" style="color: white;">إضافة عقار</a>
            </button>
        </header>

        <!-- الجدول -->
        <div class="offers-page-table" role="table" aria-label="جدول العروض">
            <div class="offers-page-thead" role="rowgroup">
                <div class="offers-page-row offers-page-row--head" role="row">
                    <div class="offers-page-col offers-page-col--image" role="columnheader">الصورة</div>
                    <div class="offers-page-col" role="columnheader">اسم الوحدة</div>
                    <div class="offers-page-col offers-page-col--price" role="columnheader">السعر</div>
                    <div class="offers-page-col offers-page-col--actions" role="columnheader" aria-label="إجراءات">إجراءات</div>
                </div>
            </div>

            <div id="offers-page-tbody" class="offers-page-tbody" role="rowgroup">
                
                @isset($offers)
                    @foreach($offers as $offer)
                        <div class="offers-page-row" role="row" data-offers-page-item>
                            <div class="offers-page-col offers-page-col--image" role="cell">
                                <img class="offers-page-thumb" src="{{ asset($offer->img) }}" alt="صورة العقار" />
                            </div>
                            <div class="offers-page-col" role="cell">
                                <div class="offers-page-unit">{{ $offer->title }}</div>
                                <div class="offers-page-meta"></div>
                            </div>
                            <div class="offers-page-col offers-page-col--price" role="cell">
                                <b class="offers-page-price">{{ $offer->price }}</b>
                            </div>
                            <div class="offers-page-col offers-page-col--actions" role="cell">
                                <button class="offers-page-chip offers-page-chip--ghost" data-action="details" type="button">
                                    <a href="{{url(route('admin/offers/details', $offer->id))}}" class="custom-link">
                                        تفاصيل العقار
                                    <a>
                                </button>
                                <button class="offers-page-chip offers-page-chip--edit" data-action="edit" type="button">
                                    <a href="{{ route('admin/offers/edit', $offer->id) }}" class="custom-link">
                                        تعديل
                                    </a>
                                </button>
                                {{-- <button class="offers-page-chip offers-page-chip--danger" data-action="delete" type="button">حذف</button> --}}
                                
                                <form action="{{ url(route('admin/offers/delete/custom', $offer->id)) }}" method="get">
                                    @csrf
                                    <button class="offers-page-chip offers-page-chip--danger delete-data-btn" type="submit">
                                        <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> حذف
                                    </button>
                                </form>
                            </div>
                        </div>
                    @endforeach
                @endisset
            </div>

    </section>
@endsection

<!-- custom js -->
@section('script')
    <script>
        (function offersPageInit() {

            $("#pages").addClass('active');
            $("#offers-screen").addClass('is-active');
            document.getElementById('nav-group').setAttribute('open', '');

            $(document).on('click', '.delete-data-btn', function (e) {
                e.preventDefault();
                let form = $(this).closest('form');
                if (confirm("هل أنت متأكد أنك تريد حذف هذه البيانات ؟")) {
                    form.submit();
                } else {
                    return false;
                }
            });
        })();
    </script>
@endsection
