@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>DashBoard</title>
@endsection

<!-- custom page -->
@section('css')
<style>
    .home-form__upload.has-image, .services-page__upload.has-image{
        background:#fff;
        border-style:solid;
    }
    .upload__img{
        max-width:100%;
        max-height:140px;
        object-fit:contain;
        display:block;
    }
    .home-form__upload.has-image .home-form__upload-text, .services-page__upload.has-image .services-page__upload-text{
        display:none;
    }
    .partner__img{
        width:100%;
        height:70px;
        object-fit:contain;
        display:block;
    }
    .home-form__upload, .home-form__partner{
        position:relative; overflow:hidden; border-radius:16px;
        border:2px dashed #e5e7eb; background:#fafafa;
    }
    .home-form__upload{ min-height:170px; }
    .home-form__partner{ width:160px; height:130px; }
    .home-form__upload.has-image .home-form__upload-text,
    .home-form__partner.has-image .home-form__upload-text{ display:none; }
    .input-container { margin-right: 20px; }
    /* .remove-partner {
        position: absolute;
        top: 10px;
        right: 6px;
    } */
</style>
@endsection

@section('content')

    <main class="main">
        <div class="topbar">
            <span class="crumb">لوحة التحكم</span>
            <div class="tools">
                <div class="tool">🔍</div>
                <div class="tool">⚙️</div>
            </div>
        </div>

        <div class="home-form__container">
            <div class="error-area" style="text-align: center; margin: 35px 0px; border: rgb(182, 12, 12);">
                @include('flash::message')
                @if ($errors->any())
                    <div style="text-align: left; margin: 15px; color: red;">
                        <ul dir="ltr">
                            @foreach ($errors->all() as $error)
                                <li class="text-danger">{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
            <form class="home-form" action="{{url(route('admin/pages/create'))}}" method="post" enctype="multipart/form-data" dir="rtl">
                @csrf
                <input type="hidden" name="page_id" value="{{ $page?->page_no ?? 1 }}">
                <div class="home-form__row">
                    <div class="home-form__stack">
                        <div class="home-form__title">إضافة العنوان الرئيسي</div>
                        <input class="home-form__input" type="text" name="title" value="{{ $page?->title }}" placeholder="نوع السكن" required>
                        <textarea class="home-form__textarea" name="info" placeholder="جملة موثوقة تفتح لك أبواب الفرص العقارية.">{!! $page?->info !!}</textarea>
                    </div>
                    <div>
                        <div class="home-form__title">إضافة الصورة الرئيسية</div>
                        <label class="home-form__upload">
                            <span class="home-form__upload-text">رفع الصورة</span>
                            <input type="file" name="base_img" accept="image/*">
                            <img class="upload__img" src="{{ asset($page?->base_img) }}">
                        </label>
                    </div>
                </div>
                {{-- <div class="home-form__two" style="margin-top:18px">
                    <div>
                        <div class="home-form__title">إضافة الاحصائيات</div>
                        <label class="home-form__upload">
                            <span class="home-form__upload-text">رفع الصورة</span>
                            <input type="file" name="statistic_img" accept="image/*">
                            <img class="upload__img" src="{{ asset($page?->statistic_img) }}">
                        </label>
                    </div>
                </div> --}}
                  
                <div class="offer-details-page-col">
                    <h3 class="offer-details-page-subtitle">أرقامنا</h3>
                    @isset($page->statistics)
                        @php $lenghtData = 1; @endphp
                        @foreach (json_decode($page->statistics) as $date)
                            @php $lenghtData += 1; @endphp
                            <div class="offer-details-page-textitem input-wrapper mb-2 d-flex" data-odp-textitem>
                                <input class="offer-details-page-input" style="width: 60%;" name="statistics[{{ $lenghtData }}][title]" value="{{ $date->title }}" type="text" placeholder="title" />
                                <input class="offer-details-page-input" style="width: 100%;" name="statistics[{{ $lenghtData }}][content]" value="{{ $date->content }}" type="text" placeholder="content" />
                                <button class="offer-details-page-remove" type="button" aria-label="حذف">✕</button>
                            </div>
                        @endforeach
                    @endisset
                    <div id="odp-statistics" class="offer-details-page-stack"></div>
                    <div class="offer-details-page-actions">
                        <button id="odp-add-amenity" class="offer-details-page-add" type="button">+</button>
                    </div>
                </div>
                        
                <!-- Second Rating -->
                <div id="second-rating-area" style="margin: 50px 0px;">
                    <div class="home-form__title">تقييمات العملاء</div>
                    <div class="home-form__title">
                        <span id="add-rating" class="btn" style="background-color: rgb(67 193 99); color: white; padding: 4px 14px;">+</span>
                    </div>
                    @isset($page?->ratings)
                        @foreach($page?->ratings as $index => $rating)
                            <div class="second-rating input-container-0" dir="rtl" style="margin-top: 5px;">
                                <div class="second-rating__ratecol second-rating__meta">
                                    <div class="second-rating__stars" aria-label="التقييم بالنجوم" dir="ltr">
                                            @for ($i = 1; $i <= 5; $i++)
                                                {{-- <i class="fa {{ $i <= $value ? 'fa-star' : 'fa-star-o' }}"></i> --}}
                                                <input id="{{ $rating->id }}sr-{{ $i }}" type="radio" value="{{ $i }}">
                                                <label for="{{ $rating->id }}sr-{{ $i }}" style="@if((int)$rating->rating >= $i) color: black; @endif">★</label>
                                            @endfor
                                        {{-- <input id="0sr-5" type="radio" value="5">
                                        <label for="0sr-5">★</label>
                                        <input id="0sr-4" type="radio" value="4">
                                        <label for="0sr-4">★</label>
                                        <input id="0sr-3" type="radio" value="3">
                                        <label for="0sr-3">★</label>
                                        <input id="0sr-2" type="radio" value="2">
                                        <label for="0sr-2">★</label>
                                        <input id="0sr-1" type="radio" value="1">
                                        <label for="0sr-1">★</label> --}}
                                    </div>
                                    
                                    <a href="{{url(route('admin/pages/remove/rating', $rating->id))}}" onclick="return confirm('هل أنت متأكد من حذف هذا التقييم؟.');">  
                                        <button type="button" class="second-rating__remove" parent-class="input-container-0" aria-label="حذف التقييم">×</button>
                                    </a>
                                    <input class="second-rating__input second-rating__input--sm" placeholder="5/3">
                                </div>
                                <div class="second-rating__stack">
                                    <input class="second-rating__input" value="{{ $rating->title }}" placeholder="أستاذة نورة">
                                    <input class="second-rating__input" value="{{ $rating->rating_at }}" type="date" placeholder="20/12/2025">
                                </div>
                                <textarea rows="4" class="second-rating__textarea" placeholder="من أفضل العقارات">{{ $rating?->comment }}</textarea>
                                <label class="second-rating__upload" style="margin-left: 32px;">
                                    <input type="file" accept="image/*">
                                    <img class="upload__img" src="{{ asset($rating?->img) }}" style="max-width: 35%;">
                                    <svg class="second-rating__upload-ico" viewBox="0 0 24 24" aria-hidden="true">
                                        <path d="M12 16V7m0 0l-4 4m4-4l4 4M6 20h12a2 2 0 002-2v-3" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                    <div class="second-rating__upload-text">رفع الصورة</div>
                                </label>
                            </div>
                        @endforeach
                    @else
                        <div class="second-rating input-container-0" dir="rtl" style="margin-top: 5px;">
                            <div class="second-rating__ratecol second-rating__meta">
                                <div class="second-rating__stars" aria-label="التقييم بالنجوم">
                                    <input id="0sr-5" type="radio" name="ratings[0][rating]" value="5">
                                    <label for="0sr-5">★</label>
                                    <input id="0sr-4" type="radio" name="ratings[0][rating]" value="4">
                                    <label for="0sr-4">★</label>
                                    <input id="0sr-3" type="radio" name="ratings[0][rating]" value="3">
                                    <label for="0sr-3">★</label>
                                    <input id="0sr-2" type="radio" name="ratings[0][rating]" value="2">
                                    <label for="0sr-2">★</label>
                                    <input id="0sr-1" type="radio" name="ratings[0][rating]" value="1">
                                    <label for="0sr-1">★</label>
                                </div>
                                <button type="button" class="remove-btn second-rating__remove" parent-class="input-container-0" aria-label="حذف التقييم">×</button>
                                <input class="second-rating__input second-rating__input--sm" placeholder="5/3">
                            </div>
                            <div class="second-rating__stack">
                                <input class="second-rating__input" name="ratings[0][title]" placeholder="أستاذة نورة">
                                <input class="second-rating__input" name="ratings[0][rating_at]" type="date" placeholder="20/12/2025">
                            </div>
                            <textarea rows="4" class="second-rating__textarea" name="ratings[0][comment]" placeholder="من أفضل العقارات"></textarea>
                            <label class="second-rating__upload" style="margin-left: 32px;">
                                <input type="file" name="ratings[0][img]" accept="image/*">
                                <svg class="second-rating__upload-ico" viewBox="0 0 24 24" aria-hidden="true">
                                    <path d="M12 16V7m0 0l-4 4m4-4l4 4M6 20h12a2 2 0 002-2v-3" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <div class="second-rating__upload-text">رفع الصورة</div>
                            </label>
                        </div>
                    @endisset
                </div>

                <div>
                    <div style="margin-top: 15px;">
                        <div class="home-form__title">شركاء النجاح</div>
                        <div class="home-form__title">
                            <span id="add-partners" class="btn" style="background-color: rgb(67 193 99); color: white; padding: 4px 14px;">+</span>
                        </div>
                        <div class="home-form__partners">

                            @isset($page?->partners)
                                @foreach($page?->partners as $index => $partner)
                                    <div class="input-container input-container-{{ $index }} mb-3">
                                        <div class="row">
        
                                            <div class="col-10" style="padding-left: 0px;">
                                                <label class="home-form__partner home-form__partner--add has-image" title="إضافة شعار شريك" style="background-image:url('{{ Storage::url($partner->logo) }}'); background-size:contain;background-repeat:no-repeat;background-position:center;">
                                                    + <input type="file" name="partner_logos[]" accept="image/*">
                                                    <img class="upload__img" src="{{ asset($partner->img) }}">
                                                </label>
                                            </div>
                                            <div class="col-2" style="padding-right: 0px;">
                                                <label for="product_variants" class="mb-2"></label>
                                                <a class="remove-partner" href="{{url(route('admin/pages/remove/partners', $partner->id))}}" onclick="return confirm('هل أنت متأكد من حذف هذا اللوجو؟.');">
                                                    <span class="badge bg-danger rounded-pill mt-4" parent-class="input-container-{{ $index }}">
                                                        <span class="btn" style="background-color: rgb(182, 12, 12); color: white;">-</span>
                                                    </span>
                                                </a>
                                            </div>
        
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="input-container input-container-0 mb-3">
                                    <div class="row">

                                        <div class="col-10">
                                            <label class="home-form__partner home-form__partner--add" title="إضافة شعار شريك">
                                                + <input type="file" name="partner_logos[]" accept="image/*">
                                            </label>
                                        </div>
                                        <div class="col-2">
                                            <label for="product_variants" class="mb-2"></label>
                                            <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-0">
                                                <span class="btn" style="background-color: rgb(182, 12, 12); color: white;">-</span>
                                            </span>
                                        </div>

                                    </div>
                                </div>
                            @endisset

                        </div>
                    </div>
                </div>
                <div class="home-form__actions">
                    <button class="home-form__btn" type="submit">حفظ التغييرات</button>
                </div>
            </form>
        </div>
    </main>

@endsection
<!-- custom js -->
@section('script')
    <script>
        let inputCount = 1000;
        $('#add-partners').click(function() {

            inputCount++;
            $('.home-form__partners').append(`
                    <div class="input-container input-container-${inputCount} mb-3">
                        <div class="row">

                            <div class="col-10" style="padding-left: 0px;">
                                <label class="home-form__partner home-form__partner--add" title="إضافة شعار شريك">
                                    + <input type="file" name="partner_logos[]" accept="image/*">
                                </label>
                            </div>
                            <div class="col-2" style="padding-right: 0px;">
                                <label for="product_variants" class="mb-2"></label>
                                <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-${inputCount}">
                                    <span class="btn" style="background-color: rgb(182, 12, 12); color: white;">-</span>
                                </span>
                            </div>

                        </div>
                    </div>
                `);
        });
        $('#add-rating').click(function() {

            inputCount++;
            $('#second-rating-area').append(`
                    <div class="second-rating input-container-${inputCount}" dir="rtl" style="margin-top: 5px;">
                        <div class="second-rating__ratecol second-rating__meta">
                            <div class="second-rating__stars" aria-label="التقييم بالنجوم">
                                <input id="${inputCount}sr-5" type="radio" name="ratings[${inputCount}][rating]" value="5">
                                <label for="${inputCount}sr-5">★</label>
                                <input id="${inputCount}sr-4" type="radio" name="ratings[${inputCount}][rating]" value="4">
                                <label for="${inputCount}sr-4">★</label>
                                <input id="${inputCount}sr-3" type="radio" name="ratings[${inputCount}][rating]" value="3">
                                <label for="${inputCount}sr-3">★</label>
                                <input id="${inputCount}sr-2" type="radio" name="ratings[${inputCount}][rating]" value="2">
                                <label for="${inputCount}sr-2">★</label>
                                <input id="${inputCount}sr-1" type="radio" name="ratings[${inputCount}][rating]" value="1">
                                <label for="${inputCount}sr-1">★</label>
                            </div>
                            <button type="button" class="remove-btn second-rating__remove" parent-class="input-container-${inputCount}" aria-label="حذف التقييم">×</button>
                            <input class="second-rating__input second-rating__input--sm" placeholder="5/3">
                        </div>
                        <div class="second-rating__stack">
                            <input class="second-rating__input" name="ratings[${inputCount}][title]" placeholder="أستاذة نورة">
                            <input class="second-rating__input" name="ratings[${inputCount}][rating_at]" type="date" placeholder="20/12/2025">
                        </div>
                        <textarea rows="4" class="second-rating__textarea" name="ratings[${inputCount}][comment]" placeholder="من أفضل العقارات"></textarea>
                        <label class="second-rating__upload" style="margin-left: 32px;">
                            <input type="file" name="ratings[${inputCount}][img]" accept="image/*">
                            <svg class="second-rating__upload-ico" viewBox="0 0 24 24" aria-hidden="true">
                                <path d="M12 16V7m0 0l-4 4m4-4l4 4M6 20h12a2 2 0 002-2v-3" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <div class="second-rating__upload-text">رفع الصورة</div>
                        </label>
                    </div>
                `);
        });
        var lenghtData = 1000000;
        $('#odp-add-amenity').on('click', function() {
            lenghtData++;
            let item = `
                <div class="offer-details-page-textitem input-wrapper mb-2 d-flex">
                    <input class="offer-details-page-input" style="width: 60%;" name="statistics[${lenghtData}][title]" type="text" placeholder="title" />
                    <input class="offer-details-page-input" style="width: 100%;" name="statistics[${lenghtData}][content]" type="text" placeholder="content" />
                    <button type="button" class="offer-details-page-remove">✕</button>
                </div>
            `;
            $('#odp-statistics').append(item);
        });

        $(document).on('click', '.remove-btn', function(e) {
            var parentClass = $(this).attr('parent-class');
            $('.' + parentClass).remove();
        });
        $(document).on('click', '.offer-details-page-remove', function () {
            $(this).closest('.input-wrapper').remove();
        });
    </script>
    <script>
        (function() {

            $("#pages").addClass('active');
            $("#home-screen").addClass('is-active');
            document.getElementById('nav-group').setAttribute('open', '');
            function previewSingle(input) {
                const file = input.files && input.files[0];
                const box = input.closest('label')
                if (!file || !box) return;
                let img = box.querySelector('.upload__img');
                if (!img) {
                    img = document.createElement('img');
                    img.className = 'upload__img';
                    box.appendChild(img);
                }
                img.src = URL.createObjectURL(file);
                box.classList.add('has-image');
            }

            function previewPartner(input) {
                const file = input.files && input.files[0];
                if (!file) return;

                const container = input.closest('.input-container, .home-form__partner, .services-page__card, label');
                if (!container) return;

                let img = container.querySelector('.partner__img');
                if (!img) {
                    img = document.createElement('img');
                    img.className = 'partner__img';

                    const label = input.closest('label') || container;
                    label.appendChild(img);
                }
                img.src = URL.createObjectURL(file);

                const label = input.closest('label');
                if (label) label.classList.add('has-image');
            }

            document.addEventListener('change', function(e) {
                const t = e.target;
                if (!(t instanceof HTMLInputElement)) return;
                if (t.type !== 'file') return;

                const isRatingImg = t.matches('[name^="ratings["][name$="[img]"]');

                if (t.name === 'base_img' || t.name === 'statistic_img' || isRatingImg) {
                    return previewSingle(t);
                }

                if (t.name === 'partner_logos[]') {
                    return previewPartner(t);
                }
            });

            document.addEventListener('click', function(e) {
                const btn = e.target.closest('.remove-btn');
                if (!btn) return;
                e.preventDefault();

                const wrap = btn.closest('.input-container, .home-form__partner, .services-page__card');
                if (!wrap) return;

                const fileInput = wrap.querySelector('input[type="file"]');
                const img = wrap.querySelector('.partner__img, .upload__img');
                if (fileInput) fileInput.value = '';
                if (img) img.remove();
                const label = wrap.querySelector('label');
                if (label) label.classList.remove('has-image');

            });
        })();
    </script>
@endsection
