@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>DashBoard</title>
@endsection

<!-- custom page -->
@section('css')
    <style>
        .home-form__upload.has-image,
        .services-page__upload.has-image {
            background: #fff;
            border-style: solid;
        }

        .upload__img {
            max-width: 100%;
            max-height: 140px;
            object-fit: contain;
            display: block;
        }

        .home-form__upload.has-image .home-form__upload-text,
        .services-page__upload.has-image .services-page__upload-text {
            display: none;
        }

        .partner__img {
            width: 100%;
            height: 70px;
            object-fit: contain;
            display: block;
        }

        .home-form__upload,
        .home-form__partner {
            position: relative;
            overflow: hidden;
            border-radius: 16px;
            border: 2px dashed #e5e7eb;
            background: #fafafa;
        }

        .home-form__upload {
            min-height: 170px;
        }

        .home-form__partner {
            width: 160px;
            height: 130px;
        }

        .home-form__upload.has-image .home-form__upload-text,
        .home-form__partner.has-image .home-form__upload-text {
            display: none;
        }
    </style>
@endsection

@section('content')

    <main class="main">
        <div class="topbar">
            <span class="crumb">خدمتنا</span>
            <div class="tools">
                <div class="tool">🔍</div>
                <div class="tool">⚙️</div>
            </div>
        </div>

        <div class="home-form__container">
            <div class="error-area" style="text-align: center; margin: 35px 0px; border: rgb(182, 12, 12);">
                @include('flash::message')
                @if ($errors->any())
                    <div style="text-align: left; margin: 15px; color: red;">
                        <ul dir="ltr">
                            @foreach ($errors->all() as $error)
                                <li class="text-danger">{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
            <form class="home-form" action="{{ url(route('admin/pages/create')) }}" method="post" enctype="multipart/form-data" dir="rtl">
                @csrf
                <input type="hidden" name="page_id" value="{{ $page?->id ?? 1 }}">
                <div class="home-form__row">
                    <div class="home-form__stack">
                        <div class="home-form__title">إضافة العنوان الرئيسي</div>
                        <input class="home-form__input" type="text" name="title" value="{{ $page?->title }}"
                            placeholder="نوع السكن" required>
                        <textarea class="home-form__textarea" name="info" placeholder="جملة موثوقة تفتح لك أبواب الفرص العقارية.">{!! $page?->info !!}</textarea>
                    </div>
                    <div>
                        <div class="home-form__title">إضافة الصورة الرئيسية</div>
                        <label class="home-form__upload">
                            <span class="home-form__upload-text">رفع الصورة</span>
                            <input type="file" name="base_img" accept="image/*">
                            <img class="upload__img" src="{{ asset($page?->base_img) }}">
                        </label>
                    </div>
                </div>

                <fieldset class="realstate-about-form__fieldset">
                    <legend class="realstate-about-form__legend">خدمتنا</legend>
                    <div class="offer-details-page-actions" dir="ltr" style="margin-top: 0px;">
                        <button id="odp-add-services" class="offer-details-page-add" type="button">+</button>
                    </div>
                    <div id="odp-services" class="offer-details-page-stack"></div>
                    

                    <div class="home-form__actions">
                        <button class="home-form__btn" type="submit">حفظ التغييرات</button>
                    </div>
                </fieldset>
            </form>
            @isset ($page->values)
                <div class="home-form mt-4" dir="rtl">
                    <fieldset class="realstate-about-form__fieldset">
                        @foreach ($page->values as $value)
                            <div class="home-form mt-4" dir="rtl">
                                <a href="{{ url(route('admin/pages/services/delete', $value->id)) }}" class="offer-details-page-remove mt-3" onclick="return confirm('هل أنت متأكد أنك تريد حذف هذه البيانات ؟')" aria-label="حذف" style="width: 5%; text-decoration: none;">✕</a>
                                <form action="{{ url(route('admin/pages/services/update', $value->id)) }}" method="post" enctype="multipart/form-data">
                                    @csrf    
                                    <div class="realstate-about-form__grid realstate-about-form__grid--row mt-3">
                                        <div class="realstate-about-form__card realstate-about-form__card--icon">
                                            <span class="realstate-about-form__label">أيقونة الخدمة</span>
                                            <label class="realstate-about-form__uploader realstate-about-form__uploader--sm" data-rsaf-dropzone>
                                                <input class="realstate-about-form__file" type="file" accept="image/*" name="img" />
                                                <div class="realstate-about-form__uploader-ui">
                                                    <div class="realstate-about-form__uploader-icon">⬆︎</div>
                                                    <div class="realstate-about-form__uploader-text">رفع</div>
                                                    <img class="realstate-about-form__uploader-preview" alt="" @if (is_null($value?->img)) hidden @else src="{{ asset($value?->img) }}" @endif />
                                                </div>
                                            </label>
                                        </div>
                                        <div class="realstate-about-form__card">
                                            <input name="value_no" type="hidden" value="5" />
                                            <label class="realstate-about-form__label" for="feature_1_title">العنوان</label>
                                            <input class="realstate-about-form__input" id="feature_1_title" name="title" value="{{ $value?->title }}" type="text" placeholder="العنوان" />
                                        </div>
                                        <div class="realstate-about-form__card">
                                            <label class="realstate-about-form__label" for="feature_1_desc">الوصف</label>
                                            <textarea class="realstate-about-form__textarea" id="feature_1_desc" name="comment" rows="2" placeholder="وصف مختصر...">{{ $value?->comment }}</textarea>
                                        </div>
                                    </div>
                                    <div class="home-form__actions">
                                        <button class="home-form__btn" type="submit">حفظ التغييرات</button>
                                    </div>
                                </form>
                            </div>
                        @endforeach
                    </fieldset>
                </div>
            @endisset
        </div>
    </main>

@endsection
<!-- custom js -->
@section('script')
    <script>
        (function() {

            $("#pages").addClass('active');
            $("#our-services-screen").addClass('is-active');
            document.getElementById('nav-group').setAttribute('open', '');

            var lenghtData = 1000000;
            $('#odp-add-services').on('click', function() {
                lenghtData++;
                let item = `
                    <button class="offer-details-page-remove mt-3" type="button" aria-label="حذف" style="width: 5%;">✕</button>
                    <div class="realstate-about-form__grid realstate-about-form__grid--row input-wrapper">
                        <div class="realstate-about-form__card realstate-about-form__card--icon">
                            <span class="realstate-about-form__label">أيقونة الخدمة</span>
                            <label class="realstate-about-form__uploader realstate-about-form__uploader--sm" data-rsaf-dropzone>
                                <input class="realstate-about-form__file" type="file" accept="image/*" name="values[${lenghtData}][img]" />
                                <div class="realstate-about-form__uploader-ui">
                                    <div class="realstate-about-form__uploader-icon">⬆︎</div>
                                    <div class="realstate-about-form__uploader-text">رفع</div>
                                    <img class="realstate-about-form__uploader-preview" alt=""/>
                                </div>
                            </label>
                        </div>
                        <div class="realstate-about-form__card">
                            <label class="realstate-about-form__label" for="feature_3_title">العنوان</label>
                            <input class="realstate-about-form__input" id="feature_3_title" name="values[${lenghtData}][title]" type="text" placeholder="العنوان" />
                        </div>
                        <div class="realstate-about-form__card">
                            <label class="realstate-about-form__label" for="feature_3_desc">الوصف</label>
                            <textarea class="realstate-about-form__textarea" id="feature_3_desc" name="values[${lenghtData}][comment]" rows="2" placeholder="وصف مختصر..."></textarea>
                        </div>
                    </div>
                `;
                $('#odp-services').append(item);
            });

            function previewSingle(input) {
                const file = input.files && input.files[0];
                const box = input.closest('label')
                if (!file || !box) return;
                let img = box.querySelector('.upload__img');
                if (!img) {
                    img = document.createElement('img');
                    img.className = 'upload__img';
                    box.appendChild(img);
                }
                img.src = URL.createObjectURL(file);
                box.classList.add('has-image');
            }

            function previewPartner(input) {
                const file = input.files && input.files[0];
                if (!file) return;

                const container = input.closest('.input-container, .home-form__partner, .services-page__card, label');
                if (!container) return;

                let img = container.querySelector('.partner__img');
                if (!img) {
                    img = document.createElement('img');
                    img.className = 'partner__img';

                    const label = input.closest('label') || container;
                    label.appendChild(img);
                }
                img.src = URL.createObjectURL(file);

                const label = input.closest('label');
                if (label) label.classList.add('has-image');
            }

            document.addEventListener('change', function(e) {
                const t = e.target;
                if (!(t instanceof HTMLInputElement)) return;
                if (t.type !== 'file') return;

                const isRatingImg = t.matches('[name^="values["][name$="[img]"]');

                if (t.name === 'base_img' || t.name === 'statistic_img' || isRatingImg) {
                    return previewSingle(t);
                }

                if (t.name === 'partner_logos[]') {
                    return previewPartner(t);
                }
            });

            document.addEventListener('click', function(e) {
                const btn = e.target.closest('.remove-btn');
                if (!btn) return;
                e.preventDefault();

                const wrap = btn.closest('.input-container, .home-form__partner, .services-page__card');
                if (!wrap) return;

                const fileInput = wrap.querySelector('input[type="file"]');
                const img = wrap.querySelector('.partner__img, .upload__img');
                if (fileInput) fileInput.value = '';
                if (img) img.remove();
                const label = wrap.querySelector('label');
                if (label) label.classList.remove('has-image');

            });
            $(document).on('click', '.offer-details-page-remove', function () {
                $(this).closest('.input-wrapper').remove();
            });
            // $(document).on('click', '.delete-data-btn', function (e) {
            //     e.preventDefault();
            //     let form = $(this).closest('form');
            //     if (confirm("هل أنت متأكد أنك تريد حذف هذه البيانات ؟")) {
            //         form.submit();
            //     } else {
            //         return false;
            //     }
            // });
        })();
    </script>
@endsection
