<!doctype html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>نوع المساكن للعقارات</title>
    <link rel="stylesheet" href="https://unpkg.com/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flag-icons@7/css/flag-icons.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;800;900&display=swap" rel="stylesheet">
    <link href="{{ asset('admin/assets/css/select_2.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('website/assets/style.css') }}" />
    <style>.select2-container, .select2.select2-container { width: 595px !important; }</style>
    @yield('css')
</head>
<body>

    @include('layouts.website.header')
    @yield('content')
    @include('layouts.website.footer')

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('website/assets/script.js') }}"></script>
    <script>
      $(function () {
        const $win = $(window);
        const $header = $('#mainHeader');
        const threshold = 10;

        function applySticky(){
          $header.toggleClass('is-stuck', $win.scrollTop() > threshold);
          $header.toggleClass('is-stuck', $(this).scrollTop() > threshold);
          $('.logo').toggleClass('height-logo', $(this).scrollTop() > threshold);
        }
        $win.on('scroll load', applySticky);
        applySticky();
      });
    </script>
    @yield('script')
</body>

</html>
