@extends('layouts.website.home')

<!-- title page -->
@section('title')
    <title>نوع المساكن</title>
@endsection

<!-- custom page -->
@section('css')
<style>
    .value-card .icon {
        width: 100% !important;
        height: 55% !important;
    }
    .media-img {
        width: 60%;
        height: 65%;
    }
    .about-split .text-card h3 {
        margin-bottom: 22px;
    }
    .about-split .text-card {
        background: none;
    }
</style>
@endsection

@section('content')

    @isset($data['page'])
        <header class="hero position-relative text-white">
            <img class="hero-bg" src="{{ asset($data['page']->base_img) }}" alt="">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-2">
                <div class="hero-content">
                    <h1 class="display-5 fw-black mb-3">{{ $data['page']->title }}</h1>
                    <p class="lead opacity-90">{{ $data['page']->info }}</p>
                </div>
            </div>
        </header>
    @endisset

    <section class="section section-cream" id="about-vision">
        <div class="container about-split">
            <div class="row g-3 align-items-stretch text-center">
                <div class="col-lg-12">
                    <article class="text-card h-100">
                        <h3>الرؤية والرسالة</h3>
                        <p class="mb-3">
                            أن نكون مؤسسة رائدة في المملكة العربية السعودية تقدّم منهجًا متكاملاً للتسويق والوساطة العقارية،
                            ونوفّر تجربة سهلة وموثوقة في رحلة العقار.
                        </p>
                        {{-- <ul class="mb-0 small text-secondary"> --}}
                            <p class="mb-1">تقديم حلول تمويل وتسويق متكاملة.</p>
                            <p class="mb-1">تحسين تجربة العميل عبر أتمتة العمليات.</p>
                            <p class="mb-1">التزام مهني بالشفافية والجودة.</p>
                        {{-- </ul> --}}
                    </article>
                </div>
                {{-- <div class="col-lg-8">
                    <div class="card-media">
                        <img class="media-img" src="{{ $data['page']->message_img ? asset($data['page']->message_img) : asset($data['page']->base_img) }}" alt="ممر وحديقة منزلية">
                    </div>
                </div> --}}
            </div>
        </div>
    </section>

    {{-- @isset($data['page']->values)
        <section class="section" id="our-values">
            <div class="container">
                <div class="values">
                    <div class="section-head">
                        <h4 class="h4">قيمنا</h4>
                    </div>

                    <div class="row g-3">
                        @foreach ($data['page']->values as $value)
                            <div class="col-12 col-md-6 col-xl-3">
                                <div class="value-card">
                                    <div class="icon">
                                        <img class="media-img" src="{{ asset($value->img) }}" alt="icon">
                                    </div>
                                    <h5>{{ $value->title }}</h5>
                                    <p>{{ $value->comment }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    
                </div>
            </div>
        </section>
    @endisset --}}

@endsection

<!-- custom js -->
@section('script')
<script>
    $(document).ready(function() {
        $('.stat-box').each(function(i) {
            setTimeout(() => {
                $(this).addClass('show');
            }, i * 200);
        });
    });
</script>
@endsection
