@extends('layouts.website.home')

<!-- title page -->
@section('title')
    <title>نوع المساكن</title>
@endsection

<!-- custom page -->
@section('css')
<style>
    .stat-box {
        background: #fff;
        border-radius: 15px;
        padding: 20px;
        box-shadow: 0 10px 10px rgba(0,0,0,0.05);
        opacity: 0;
        transform: scale(0.9);
        transition: all 0.5s ease-in-out;
    }
    .stat-box.show {
        opacity: 1;
        transform: scale(1);
    }
    .stat-box:hover {
        transform: translateY(-5px) scale(1.03);
        box-shadow: 0 6px 15px rgba(0,0,0,0.1);
    }
    .card-img-top {
        width: 100%;
        height: 250px;
        object-fit: cover;
        border-radius: 8px;  
    }
    .partner-logo {
        max-width: 140px;
        max-height: 100px;
        object-fit: contain;
        filter: grayscale(100%);
        transition: 0.3s;
        margin: 0px 25px;
    }
    .partner-logo:hover {
        filter: grayscale(0%);
        transform: scale(1.05);
    }
    .carousel-control-prev-icon, .carousel-control-next-icon {
        background-image: none !important;
        background-color: #303030 !important;
        padding: 25px !important;
    }
    .custom-carousel-icon {
        width: 45px;
        height: 45px;
        background-color: rgba(0, 0, 0, 0.4); 
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .carousel-control-prev-icon::after {
        content: "‹";  
        font-size: 28px;
        color: #fff;
        font-weight: bold;
    }
    .carousel-control-next-icon::after {
        content: "›"; 
        font-size: 28px;
        color: #fff;
        font-weight: bold;
    }
    .custom-carousel-icon:hover {
        background-color: rgba(0, 0, 0, 0.7);
    }
    #partnersCarouselRatinf {
        margin-bottom: 8% !important;
    }
    .carousel-control-next-icon, .carousel-control-prev-icon {
        height: 6rem !important;
    }
</style>
@endsection

@section('content')

    @isset($data['page'])
        <header class="hero position-relative text-white">
            <img class="hero-bg" src="{{ asset($data['page']->base_img) }}" alt="">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-2">
                <div class="hero-content">
                    <h1 class="display-5 fw-black mb-3">{{ $data['page']->title }}</h1>
                    <p class="lead opacity-90">{{ $data['page']->info }}</p>
                </div>
            </div>
        </header>
    @endisset

    @isset($data['realestate'])
        <section class="section-padding bg-cream">
            <div class="container">
                <h2 class="section-title">أحدث العروض العقارية</h2>

                <div id="offersCarousel" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">

                        @foreach ($data['realestate']->chunk(3) as $chunk)
                            <div class="carousel-item {{ $loop->first ? 'active' : '' }}">
                                <div class="row g-3">
                                    @foreach ($chunk as $realestate)
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <article class="property-card card h-100 shadow-sm">
                                                <div class="position-relative overflow-hidden">
                                                    <a href="{{ url(route('website/details/offer', $realestate->id)) }}" class="prop-title">
                                                        <img class="card-img-top" src="{{ asset($realestate->img) }}" alt="عقار">
                                                    </a>
                                                    @php
                                                        $backgroundColor = '';
                                                        if ($realestate->status === 'متاح') {
                                                            $backgroundColor = 'background: #eaf7ef; color: #1f7a42; padding: 4px 7px; border-radius: 10px;';
                                                        }elseif ($realestate->status === 'مباع') {
                                                            $backgroundColor = 'background: #ffe8e8; color: #a01a1a; padding: 4px 7px; border-radius: 10px;';
                                                        }elseif ($realestate->status === 'محجوز') {
                                                            $backgroundColor = 'background: #fff4e6; color: #a35600; padding: 4px 7px; border-radius: 10px;';
                                                        }
                                                    @endphp
                                                    <span class="@if(empty($backgroundColor)) badge bg-primary @endif position-absolute top-0 start-0 m-2" style="{{ $backgroundColor }}">{{ $realestate->status }}</span>
                                                </div>
                                                <div class="card-body">
                                                    {{-- <h5 class="card-title">{{ $realestate->title }}</h5> --}}
                                                    <a href="{{ url(route('website/details/offer', $realestate->id)) }}" class="prop-title">{{ $realestate->title }}</a>
                                                    <div class="price">ر.س <span>{{ $realestate->price }}</span></div>
                                                    <ul class="icon-specs list-unstyled d-flex flex-wrap gap-3 mt-3">
                                                        <li><i class="bi bi-house-door"></i> {{ $realestate->rooms_count }} غرف</li>
                                                        <li><i class="bi bi-droplet"></i> {{ $realestate->bathrooms_count }} دورات مياه</li>
                                                        <li><i class="bi bi-aspect-ratio"></i> {{ $realestate->area }}</li>
                                                        <li><i class="bi bi-car-front"></i> {{ $realestate->parking_count }} {{ $realestate->parking_count > 2 ? 'مواقف' : 'موقف' }}</li>
                                                    </ul>
                                                </div>
                                            </article>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endforeach

                    </div>

                    <button class="carousel-control-prev" type="button" data-bs-target="#offersCarousel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">السابق</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#offersCarousel" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">التالي</span>
                    </button>
                </div>
            </div>
        </section>
    @endisset

    @isset($data['exclusive'])
        <section class="section-padding"> 
            <div class="container">
                <h2 class="section-title">المشاريع الحصرية</h2>

                <div id="projectsCarousel" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                    
                        @foreach ($data['exclusive']->chunk(3) as $chunk)
                            <div class="carousel-item {{ $loop->first ? 'active' : '' }}">
                                <div class="row g-3">
                                    @foreach ($chunk as $realestate)
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <article class="property-card card h-100 shadow-sm">
                                                <div class="position-relative overflow-hidden">
                                                    <a href="{{ url(route('website/details/offer', $realestate->id)) }}" class="prop-title">
                                                        <img class="card-img-top" src="{{ asset($realestate->img) }}" alt="عقار">
                                                    </a>
                                                    @php
                                                        $backgroundColor = '';
                                                        if ($realestate->status === 'متاح') {
                                                            $backgroundColor = 'background: #eaf7ef; color: #1f7a42; padding: 4px 7px; border-radius: 10px;';
                                                        }elseif ($realestate->status === 'مباع') {
                                                            $backgroundColor = 'background: #ffe8e8; color: #a01a1a; padding: 4px 7px; border-radius: 10px;';
                                                        }elseif ($realestate->status === 'محجوز') {
                                                            $backgroundColor = 'background: #fff4e6; color: #a35600; padding: 4px 7px; border-radius: 10px;';
                                                        }
                                                    @endphp
                                                    <span class="@if(empty($backgroundColor)) badge bg-primary @endif position-absolute top-0 start-0 m-2" style="{{ $backgroundColor }}">{{ $realestate->status }}</span>
                                                </div>
                                                <div class="card-body">
                                                    {{-- <h5 class="card-title">{{ $realestate->title }}</h5> --}}
                                                    <a href="{{ url(route('website/details/offer', $realestate->id)) }}" class="prop-title">{{ $realestate->title }}</a>
                                                    <div class="price">ر.س <span>{{ $realestate->price }}</span></div>
                                                    <ul class="icon-specs list-unstyled d-flex flex-wrap gap-3 mt-3">
                                                        <li><i class="bi bi-house-door"></i> {{ $realestate->rooms_count }} غرف</li>
                                                        <li><i class="bi bi-droplet"></i> {{ $realestate->bathrooms_count }} دورات مياه</li>
                                                        <li><i class="bi bi-aspect-ratio"></i> {{ $realestate->area }}</li>
                                                        <li><i class="bi bi-car-front"></i> {{ $realestate->parking_count }} {{ $realestate->parking_count > 2 ? 'مواقف' : 'موقف' }}</li>
                                                    </ul>
                                                </div>
                                            </article>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endforeach

                    </div>

                    <button class="carousel-control-prev" type="button" data-bs-target="#projectsCarousel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">السابق</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#projectsCarousel" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">التالي</span>
                    </button>
                </div>
            </div>
        </section>
    @endisset

    @isset($data['page']->statistics)
        <section class="section-padding bg-cream">
            <div class="container">
                <h2 class="section-title">أرقامنا</h2>
                <div class="row g-3">

                    
                    @foreach (json_decode($data['page']->statistics) as $date)
                        <div class="col-6 col-lg-4">
                            <div class="stat-box">
                                {{-- <div class="stat-value">650 <small>مليون ريال</small></div> --}}
                                <div class="stat-value">{{ $date->title }}</div>
                                <div class="stat-text">{{ $date->content }}</div>
                            </div>
                        </div>
                    @endforeach
                    

                    {{-- <div class="col-6 col-lg-4">
                    <div class="stat-box">
                        <div class="stat-value">650 <small>مليون ريال</small></div>
                        <div class="stat-text">إجمالي حجم تمويلك عن طريق نوع المساكن بالتعاون مع جهات التمويل</div>
                    </div>
                    </div>
                    <div class="col-6 col-lg-4">
                    <div class="stat-box">
                        <div class="stat-value">250<span>%</span></div>
                        <div class="stat-text">كفاءة في العملية البيعية (عن طريق أتمتة العمليات)</div>
                    </div>
                    </div>
                    <div class="col-6 col-lg-4">
                    <div class="stat-box">
                        <div class="stat-value">4<span>x</span></div>
                        <div class="stat-text">سرعة بيع العقار مقارنة بمتوسط السوق (متوسط البيع 4 أسابيع)</div>
                    </div>
                    </div>
                    <div class="col-6 col-lg-4">
                    <div class="stat-box">
                        <div class="stat-value">4000</div>
                        <div class="stat-text">عقود الوساطة العقارية</div>
                    </div>
                    </div>
                    <div class="col-6 col-lg-4">
                    <div class="stat-box">
                        <div class="stat-value">6000</div>
                        <div class="stat-text">عقود الإيجار</div>
                    </div>
                    </div>
                    <div class="col-6 col-lg-4">
                    <div class="stat-box">
                        <div class="stat-value">120 <small>ألف</small></div>
                        <div class="stat-text">عدد الزيارات الشهرية لمنصة نوع المساكن</div>
                    </div>
                    </div> --}}
                </div>
            </div>
        </section>
    @endisset

  {{-- <section class="section-padding bg-cream">
    <div class="container">
        <img src="{{ asset($data['page']->statistic_img) }}" alt="" style="max-width: inherit;"/>
    </div>
  </section> --}} 

    @if(isset($data['ratings']) || isset($data['partners']))
        <section id="ratings-partners-section" class="section-padding">
            <div class="container">
                @isset($data['ratings'])
                    <h2 class="section-title">تقييمات العملاء</h2>
                    <div id="partnersCarouselRatinf" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            @foreach($data['ratings']->chunk(3) as $index => $chunk)
                            <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                                <div class="d-flex justify-content-center gap-3">
                                    @foreach($chunk as $rating)
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <div class="card shadow-sm h-100">
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center gap-2 mb-2">
                                                        <img src="{{ asset($rating->img) }}" alt="" class="rounded-circle" width="44" height="44">
                                                        <div>
                                                            <div class="fw-semibold">{{ $rating->title }}</div>
                                                            <div class="small text-muted">{{ $rating->rating_at }}</div>
                                                        </div>
                                                    </div>
                                                    <p class="mb-2">{{ $rating->content }}</p>
                                                    <div class="rating" data-value="{{ $rating->rating }}">
                                                        @for ($forLoop = 1; $forLoop < 6; $forLoop++)
                                                            <i class="bi @if($rating->rating >= $forLoop) bi-star-fill @else bi-star @endif"></i>
                                                        @endfor
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            @endforeach
                        </div>

                        <button class="carousel-control-prev" type="button" data-bs-target="#partnersCarouselRatinf" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon custom-carousel-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#partnersCarouselRatinf" data-bs-slide="next">
                            <span class="carousel-control-next-icon custom-carousel-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                @endisset

                @isset($data['partners'])
                    <div class="partners mt-5 mb-4">
                        <h2 class="section-title">شركاء النجاح</h2>
                        <div id="partnersCarouselPartners" class="carousel slide" data-bs-ride="carousel">
                            <div class="carousel-inner">
                                @foreach($data['partners']->chunk(6) as $index => $chunk)
                                <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                                    <div class="d-flex justify-content-center gap-3">
                                        @foreach($chunk as $partner)
                                            <img src="{{ asset($partner->img) }}" class="d-block partner-logo" alt="partner">
                                        @endforeach
                                    </div>
                                </div>
                                @endforeach
                            </div>

                            <button class="carousel-control-prev" type="button" data-bs-target="#partnersCarouselPartners" data-bs-slide="prev">
                                <span class="carousel-control-prev-icon custom-carousel-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Previous</span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#partnersCarouselPartners" data-bs-slide="next">
                                <span class="carousel-control-next-icon custom-carousel-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Next</span>
                            </button>
                        </div>
                    </div>
                @endisset
            </div>
        </section>
    @endif

@endsection

<!-- custom js -->
@section('script')
<script>
    $(document).ready(function() {
        $('.stat-box').each(function(i) {
            setTimeout(() => {
                $(this).addClass('show');
            }, i * 200);
        });
    });
</script>
@endsection
