@extends('layouts.website.home')

<!-- title page -->
@section('title')
    <title>نوع المساكن</title>
@endsection

<!-- custom page -->
@section('css')
<style>
    .nearby-card {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 10px 15px;
        border-radius: 8px;
        background: #f5f5ff;
    }
    .nearby-ico {
        background: #e6e6ff;
        color: #3c3c8c;
        border-radius: 50%;
        padding: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .nearby-text {
        flex: 1;
        text-align: right;
    }
    .carousel-item img, .carousel-item video {
        width: 100%;
        height: 500px;
        object-fit: cover;
        border-radius: 8px;
    }
    .carousel-control-prev-icon, .carousel-control-next-icon {
        background-image: none !important;
    }
    .custom-carousel-icon {
        width: 45px;
        height: 45px;
        background-color: rgba(0, 0, 0, 0.4); 
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .carousel-control-prev-icon::after {
        content: "‹"; 
        font-size: 28px;
        color: #fff;
        font-weight: bold;
    }
    .carousel-control-next-icon::after {
        content: "›"; 
        font-size: 28px;
        color: #fff;
        font-weight: bold;
    }
    .custom-carousel-icon:hover {
        background-color: rgba(0, 0, 0, 0.7);
    }
</style>
@endsection

@section('content')

    @isset($data['page'])
        <header class="hero position-relative text-white">
            <img class="hero-bg" src="{{ asset($data['page']->base_img) }}" alt="">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-2">
                <div class="hero-content">
                    <h1 class="display-5 fw-black mb-3">{{ $data['page']->title }}</h1>
                    <p class="lead opacity-90">{{ $data['page']->info }}</p>
                </div>
            </div>
        </header>
    @endisset

    @isset($data['offer'])
        <section id="property-details" class="section section-cream">
            <div class="container">

                <section class="section section-cream" style="padding-top: 26px !important;">
                    <div class="container">
                        <h3 class="section-subtitle">تفاصيل العقار</h3>

                        <div class="row g-3">
                            
                            @isset($data['offer']->details)
                                @foreach($data['offer']->details as $detail)
                                    @php
                                        $backgroundColor = '';
                                        if ($detail->offer_status === 'متاح') {
                                            $backgroundColor = 'background: #eaf7ef; color: #1f7a42; padding: 4px 7px; border-radius: 10px;';
                                        }elseif ($detail->offer_status === 'مباع') {
                                            $backgroundColor = 'background: #ffe8e8; color: #a01a1a; padding: 4px 7px; border-radius: 10px;';
                                        }elseif ($detail->offer_status === 'محجوز') {
                                            $backgroundColor = 'background: #fff4e6; color: #a35600; padding: 4px 7px; border-radius: 10px;';
                                        }
                                    @endphp
                                    <div class="col-12 col-md-6 col-lg-3">
                                        <div class="new-mini-card">
                                            <div class="new-mini-top">
                                                <span class="new-mini-badge is-available" style="{{ $backgroundColor }}">{{ $detail->offer_status }}</span>
                                                <span class="new-mini-meta">رقم العرض: <b>{{ $detail->offer_number }}</b></span>
                                            </div>
                                            <button href="#" class="new-mini-cta" data-bs-toggle="modal" data-bs-target="#exampleModal-{{ $detail->id }}">شاهد التفاصيل</button>
                                            <div class="modal fade" id="exampleModal-{{ $detail->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">

                                                            <div class="new-md-sheet">

                                                                <div class="new-md-headline" dir="ltr">
                                                                    <div class="d-flex align-items-center gap-2">
                                                                        <span class="badge new-ok new-md-status" style="{{ $backgroundColor }}">{{ $detail->offer_status }}</span>
                                                                    </div>
                                                                    <h5 class="new-md-offer m-0">
                                                                        <span class="text-muted">رقم العرض:</span>
                                                                        <b>{{ $detail->offer_number }}</b>
                                                                    </h5>
                                                                </div>
                                                                <div class="new-md-table">

                                                                    <div class="new-md-row">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-building"></i> الدور
                                                                        </div>
                                                                        <div class="new-md-val">{{ $detail->floor }}</div>
                                                                    </div>
                                                                    <div class="new-md-row">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-aspect-ratio"></i> المساحة
                                                                        </div>
                                                                        <div class="new-md-val"><b>{{ $detail->area }}</b><sup></sup></div>
                                                                    </div>
                                                                    <div class="new-md-row">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-door-open"></i> الغرف
                                                                        </div>
                                                                        <div class="new-md-val">{{ $detail->rooms_count }}</div>
                                                                    </div>
                                                                    <div class="new-md-row">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-compass"></i> الواجهة
                                                                        </div>
                                                                        <div class="new-md-val">{{ $detail->front }}</div>
                                                                    </div>
                                                                    <div class="new-md-row is-accent">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-cash-coin"></i> السعر
                                                                        </div>
                                                                        <div class="new-md-val new-md-price">
                                                                            <span class="new-md-price-num">{{ $detail->price }}</span>
                                                                            <span class="new-md-price-cur">ر.س</span>
                                                                        </div>
                                                                    </div>

                                                                </div>

                                                                <div class="new-md-note small text-muted">
                                                                    آخر تحديث: امس 12:30 م
                                                                </div>
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                            <!-- <button type="button" class="btn btn-primary">Save changes</button> -->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endisset

                        </div>
                    </div>
                </section>

                <h3 class="section-subtitle">معلومات المشروع</h3>
                <div class="info-table mb-5">
                    @if (!is_null($data['offer']->pro_info_offer_number) && !empty($data['offer']->pro_info_offer_number))
                        <div class="info-row">
                            <div class="info-key">رقم الرخصة</div>
                            <div class="info-val">{{ $data['offer']->pro_info_offer_number }}</div>
                        </div>
                    @endif
                    @if (!is_null($data['offer']->pro_info_city) && !empty($data['offer']->pro_info_city))
                        <div class="info-row">
                            <div class="info-key">المدينة</div>
                            <div class="info-val">{{ $data['offer']->pro_info_city }}</div>
                        </div>
                    @endif
                    @if (!is_null($data['offer']->pro_info_region) && !empty($data['offer']->pro_info_region))
                        <div class="info-row">
                            <div class="info-key">الحي</div>
                            <div class="info-val">{{ $data['offer']->pro_info_region }}</div>
                        </div>
                    @endif
                    @if (!is_null($data['offer']->pro_info_details) && !empty($data['offer']->pro_info_details))
                        <div class="info-row">
                            <div class="info-key">الوصف</div>
                            <div class="info-val">{{ $data['offer']->pro_info_details }}</div>
                        </div>
                    @endif
                    @if (!is_null($data['offer']->pro_info_rooms_count) && !empty($data['offer']->pro_info_rooms_count))
                        <div class="info-row">
                            <div class="info-key">الغرف</div>
                            <div class="info-val">{{ $data['offer']->pro_info_rooms_count }}</div>
                        </div>
                    @endif
                    @if (!is_null($data['offer']->pro_info_floor) && !empty($data['offer']->pro_info_floor))
                        <div class="info-row">
                            <div class="info-key">الطوابق</div>
                            <div class="info-val">{{ $data['offer']->pro_info_floor }}</div>
                        </div>
                    @endif
                </div>

                @isset($data['offer']->nears_from)
                    <h3 class="section-subtitle">بالقرب من</h3>
                    <div class="row g-2 g-md-3">

                        @foreach (explode(',', $data['offer']->nears_from) as $date)
                            <div class="col-12 col-md-4">
                                <a class="nearby-card d-flex align-items-center justify-content-between" href="#">
                                    <span class="nearby-ico">
                                        <i class="bi bi-geo-alt"></i>
                                    </span>
                                    <span class="nearby-text">{{ $date }}</span>
                                </a>
                            </div>
                        @endforeach

                    </div>
                @endisset

            </div>
        </section>

        <section class="section section-cream">
            <div class="container">

            @isset($data['offer']->features)
                <h3 class="section-subtitle">مميزات المشروع</h3>
                <div class="row g-2 g-md-3 features-grid mb-4">
                
                    @foreach (explode(',', $data['offer']->features) as $date)
                        <div class="col-6 col-lg-3">
                            <div class="chip-feature"><i class="bi bi-check2-circle"></i> {{ $date }}</div>
                        </div>
                    @endforeach
                </div>
            @endisset

            @isset($data['offer']->guarantees)
                <h3 class="section-subtitle mt-5">الضمانات</h3>
                <div class="row g-3 mb-4 guarantees-grid">
                    @foreach (json_decode($data['offer']->guarantees) as $date)
                        <div class="col-6 col-xl-3">
                            <div class="guarantee-item">
                                <div class="g-badge">
                                    <div class="g-num">{{ $date->years }} <br><span class="g-unit">سنوات</span></div>
                                </div>
                                <div class="g-title">{{ $date->content }}</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endisset

            @isset($data['offer']->media)
                <h3 class="section-subtitle mt-5">الصور والفيديو</h3>
                <div class="gallery-card">
                    <div id="mediaCarousel" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            @foreach ($data['offer']->media as $file)
                                <div class="carousel-item {{ $loop->last ? 'active' : '' }}">
                                    @php
                                        $ext = pathinfo($file->img, PATHINFO_EXTENSION);
                                    @endphp
                                    @if(in_array(strtolower($ext), ['jpg','jpeg','png','gif','webp','svg']))
                                        <img src="{{ asset($file->img) }}" class="d-block w-100 gallery-img mx-auto" alt="">
                                    @elseif(in_array(strtolower($ext), ['mp4','mov','avi','wmv','mkv']))
                                        <video controls>
                                            <source src="{{ asset($file->img) }}" type="video/{{ $ext }}">
                                            متصفحك لا يدعم تشغيل الفيديو
                                        </video>
                                    @endif
                                    {{-- <img src="{{ asset($file->img) }}" class="d-block w-100 gallery-img" alt=""> --}}
                                </div>
                            @endforeach
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#mediaCarousel" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon custom-carousel-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#mediaCarousel" data-bs-slide="next">
                            <span class="carousel-control-next-icon custom-carousel-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>
            @endisset

            </div>
        </section>

    @endisset
@endsection

<!-- custom js -->
@section('script')
    <script>
        $(document).ready(function() {
            $('.stat-box').each(function(i) {
                setTimeout(() => {
                    $(this).addClass('show');
                }, i * 200);
            });
        });
    </script>
@endsection
