@extends('layouts.website.home')

<!-- title page -->
@section('title')
    <title>نوع المساكن</title>
@endsection

<!-- custom page -->
@section('css')
<style>
    .value-card .icon {
        width: 100% !important;
        height: 55% !important;
    }
    .media-img {
        width: 60%;
        height: 65%;
    }
    .about-split .text-card h3 {
        margin-bottom: 22px;
    }
    .about-split .text-card {
        background: none;
    }
</style>
<style>
    .features .wrap{
        display:grid;
        grid-template-columns: repeat(3, minmax(0,1fr));
        gap: 18px 28px;
        max-width: 680px;
    }
    .features .item{
        display:flex;
        align-items:center;
        gap: 10px;
        flex-direction: row-reverse;
    }
    .features .item i{
        font-size: 26px;
        line-height: 1;
    }
    .features .item span{
        font-size: 14px;
        font-weight: 600;
        white-space: nowrap;
    }
    @media (max-width: 640px){
        .features .wrap{ grid-template-columns: repeat(2, minmax(0,1fr)); }
    }
    @media (max-width: 380px){
        .features .wrap{ grid-template-columns: 1fr; }
    }
</style>
@endsection

@section('content')

    @isset($data['page'])
        <header class="hero position-relative text-white">
            <img class="hero-bg" src="{{ asset($data['page']->base_img) }}" alt="">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-2">
                <div class="hero-content">
                    <h1 class="display-5 fw-black mb-3">{{ $data['page']->title }}</h1>
                    <p class="lead opacity-90">{{ $data['page']->info }}</p>
                </div>
            </div>
        </header>
    @endisset

    @isset($data['realestate'])
        <section id="offers" class="section section-cream">
            <div class="container">
                <h2 class="section-title">العروض العقارية</h2>

                <div class="row g-3">
                    @foreach($data['realestate'] as $realestate)
                        <div class="col-12 col-md-6 col-lg-4">
                            <article class="property-card card h-100">
                                <div class="prop-media">
                                    {{-- <img src="{{ asset($realestate->img) }}" class="prop-img" alt=""> --}}
                                    <a href="{{ url(route('website/details/offer', $realestate->id)) }}" class="prop-title">
                                        <img class="prop-img" src="{{ asset($realestate->img) }}" alt="عقار">
                                    </a>
                                    @php
                                        $backgroundColor = '';
                                        if ($realestate->status === 'متاح') {
                                            $backgroundColor = 'background: #eaf7ef; color: #1f7a42; padding: 4px 7px; border-radius: 10px;';
                                        }elseif ($realestate->status === 'مباع') {
                                            $backgroundColor = 'background: #ffe8e8; color: #a01a1a; padding: 4px 7px; border-radius: 10px;';
                                        }elseif ($realestate->status === 'محجوز') {
                                            $backgroundColor = 'background: #fff4e6; color: #a35600; padding: 4px 7px; border-radius: 10px;';
                                        }
                                    @endphp
                                    <span class="@if(empty($backgroundColor)) badge bg-primary @endif prop-badge" style="{{ $backgroundColor }}">{{ $realestate->status }}</span>
                                </div>
                                <div class="card-body">
                                    <a href="{{ url(route('website/details/offer', $realestate->id)) }}" class="prop-title">{{ $realestate->title }}</a>
                                    <div class="prop-price">ر.س <span>{{ $realestate->price }}</span></div>

                                    <div class="wrap">
                                        <div class="row">
                                            <div class="col-md-4 col-sm-6">
                                                <div class="item">
                                                    <i class="bi bi-buildings"></i>
                                                    <span style="font-size: 15px;">المدينة</span>
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-sm-6">
                                                <div class="item">
                                                    <i class="bi bi-house-door"></i>
                                                    <span style="font-size: 15px;">الغرف</span>
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-sm-6">
                                                <div class="item">
                                                    <i class="bi bi-droplet"></i>
                                                    <span style="font-size: 15px;">دورات المياه</span>
                                                </div>
                                            </div>

                                            <div class="col-md-4 col-sm-6">
                                                <div class="item">
                                                    <i class="bi bi-building"></i>
                                                    <span style="font-size: 15px;">الواجهة</span>
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-sm-6">
                                                <div class="item">
                                                    <i class="bi bi-p-circle"></i>
                                                    <span style="font-size: 15px;">مواقف السيارة</span>
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-sm-6">
                                                <div class="item">
                                                    <i class="bi bi-rulers"></i>
                                                    <span style="font-size: 15px;">المساحة</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    {{-- <ul class="prop-specs">
                                        <li><i class="bi bi-house-door"></i> غرف</li>
                                        <li><i class="bi bi-droplet"></i> دورات مياه</li>
                                        <li><i class="bi bi-aspect-ratio"></i> </li>
                                        <li><i class="bi bi-car-front"></i> موقف</li>
                                    </ul> --}}
                                    {{-- <ul class="prop-specs">
                                        <li><i class="bi bi-house-door"></i> {{ $realestate->rooms_count }} غرف</li>
                                        <li><i class="bi bi-droplet"></i> {{ $realestate->bathrooms_count }} دورات مياه</li>
                                        <li><i class="bi bi-aspect-ratio"></i> {{ $realestate->area }}</li>
                                        <li><i class="bi bi-car-front"></i> {{ $realestate->parking_count }} {{ $realestate->parking_count > 2 ? 'مواقف' : 'موقف' }}</li>
                                    </ul>

                                    <ul class="prop-meta">
                                        <li><i class="bi bi-geo-alt"></i> {{ $realestate->city }}</li>
                                        <li><i class="bi bi-area"></i> {{ $realestate->area }} </li>
                                        <li><i class="bi bi-calendar2"></i> جديد</li>
                                    </ul> --}}
                                </div>
                            </article>
                        </div>
                    @endforeach
                </div>

            </div>
        </section>
    @endisset


@endsection

<!-- custom js -->
@section('script')
<script>
    $(document).ready(function() {
        $('.stat-box').each(function(i) {
            setTimeout(() => {
                $(this).addClass('show');
            }, i * 200);
        });
    });
</script>
@endsection
