@extends('layouts.website.home')

<!-- title page -->
@section('title')
    <title>نوع المساكن</title>
@endsection

<!-- custom page -->
@section('css')
@endsection

@section('content')
    
    @isset($data['page'])
        <header class="hero position-relative text-white">
            <img class="hero-bg" src="{{ asset($data['page']->base_img) }}" alt="">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-2">
                <div class="hero-content">
                    <h1 class="display-5 fw-black mb-3">{{ $data['page']->title }}</h1>
                    <p class="lead opacity-90">{{ $data['page']->info }}</p>
                </div>
            </div>
        </header>
    @endisset

    <section class="section section-cream new-request-section" dir="rtl">
        <div class="container">

            <div class="new-intro-bar mb-4">
                <h3 class="m-0">سجل طلبك العقاري <span class="arrow">↠</span></h3>
            </div>
            @include('flash::message')
            @if ($errors->any())
                <div style="text-align: left; margin: 15px;">
                    <ul dir="ltr">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{$error}}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="row g-4">
                <aside class="col-lg-4">
                    <div class="new-sidecard3">
                        <img class="new-sc3-illus" src="{{ asset('website/assets/merged-illustration.png') }}" alt="تواصل مع مسوقين عقاريين">

                        <h5 class="new-sc3-title">تواصل مباشرةً مع مسوقين عقاريين</h5>
                        <ul class="new-sc3-list">
                            <li>
                                <i class="bi bi-journal-check"></i>
                                <span>سجل طلبك العقاري</span>
                            </li>
                            <li>
                                <i class="bi bi-telephone"></i>
                                <span>تلقّ مكالمات مباشرة من مسوقين عقاريين</span>
                            </li>
                        </ul>
                    </div>
                </aside>

                <div class="col-lg-8">
                    <form class="new-form-card" action="{{url(route('website/store/reuest'))}}" method="post">
                        @csrf
                        <div class="mb-3">
                            <label class="new-label">الهدف</label>
                            <div class="new-chip-group">
                                <input class="btn-check" type="radio" name="purpose" value="بيع" id="p-buy" checked>
                                <label class="new-chip" for="p-buy">بيع</label>
                                <input class="btn-check" type="radio" name="purpose" value="إيجار" id="p-rent">
                                <label class="new-chip" for="p-rent">إيجار</label>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="new-label">الفئة</label>
                            <div class="new-chip-group">
                                <input class="btn-check" type="radio" value="سكني" name="category" id="cat-res" checked>
                                <label class="new-chip" for="cat-res">سكني</label>
                                <input class="btn-check" type="radio" value="تجاري" name="category" id="cat-com">
                                <label class="new-chip" for="cat-com">تجاري</label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="new-label">نوع العقار</label>
                            <div class="new-chip-group flex-wrap">
                                <input class="btn-check" type="radio" value="أرض" name="ptype" id="t-land" checked>
                                <label class="new-chip" for="t-land">أرض</label>

                                <input class="btn-check" type="radio" value="شقة" name="ptype" id="t-apartment">
                                <label class="new-chip" for="t-apartment">شقة</label>

                                <input class="btn-check" type="radio" value="فيلا" name="ptype" id="t-villa">
                                <label class="new-chip" for="t-villa">فيلا</label>

                                <input class="btn-check" type="radio" value="دوبلكس" name="ptype" id="t-duplex">
                                <label class="new-chip" for="t-duplex">دوبلكس</label>

                                <input class="btn-check" type="radio" value="دور" name="ptype" id="t-floor">
                                <label class="new-chip" for="t-floor">دور</label>

                                <input class="btn-check" type="radio" value="محل" name="ptype" id="t-shop">
                                <label class="new-chip" for="t-shop">محل</label>

                                <input class="btn-check" type="radio" value="مكتب" name="ptype" id="t-office">
                                <label class="new-chip" for="t-office">مكتب</label>
                            </div>
                        </div>

                        <div class="row g-3">
                            <div class="col-12">
                                <label class="new-label">ميزانية الشراء</label>
                                <input type="number" name="buy_budget" class="form-control new-input" placeholder="أدخل ميزانيتك">
                            </div>
                            <div class="col-12">
                                <label class="new-label">ميزانية الاستثمار</label>
                                <input type="number" name="invest_budget" class="form-control new-input" placeholder="أدخل ميزانية الاستثمار">
                            </div>
                        </div>

                        <div class="mt-3">
                            <label class="new-label">المدينة</label>
                            <select class="form-select new-input" name="city">
                                <option selected disabled>ابحث بحسب المدينة</option>
                                <option value="الرياض">الرياض</option>
                                <option value="جدة">جدة</option>
                                <option value="مكة">مكة</option>
                                <option value="الدمام">الدمام</option>
                            </select>
                        </div>

                        <div class="row g-3 mt-1">
                            <div class="col-12">
                                <label class="new-label">الاسم الكامل</label>
                                <input type="text" name="full_name" class="form-control new-input" placeholder="الاسم كما في الهوية">
                            </div>
                            <div class="col-12">
                                <label class="new-label">رقم الجوال</label>
                                <input type="tel" name="phone" class="form-control new-input" placeholder="05XXXXXXXX">
                            </div>
                        </div>

                        <div class="mt-2">
                            <label class="new-label">(اختياري) نوع العميل</label>
                            <div class="new-chip-group">
                                <input class="btn-check" type="radio" value="يبحث عن عقار" name="ctype" id="c-seeker" checked>
                                <label class="new-chip" for="c-seeker">يبحث عن عقار</label>

                                <input class="btn-check" type="radio" value="مستثمر" name="ctype" id="c-investor">
                                <label class="new-chip" for="c-investor">مستثمر</label>
                            </div>
                        </div>

                        <div class="form-check mt-3">
                            <input class="form-check-input" type="checkbox" value="1" name="agree" id="agree" checked>
                            <label class="form-check-label small" for="agree">
                                أوافق على إرسال الطلب لفريق مسوقي نوع المساكن
                            </label>
                        </div>

                        <div class="mt-3">
                            <button type="submit" class="btn new-submit w-100">إرسال</button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </section>
@endsection

<!-- custom js -->
@section('script')
@endsection
