@extends('layouts.website.home')

<!-- title page -->
@section('title')
    <title>نوع المساكن</title>
@endsection

<!-- custom page -->
@section('css')
<style>
    .value-card .icon {
        width: 100% !important;
        height: 55% !important;
    }
    .media-img {
        width: 60%;
        height: 65%;
    }
    .about-split .text-card h3 {
        margin-bottom: 22px;
    }
    .about-split .text-card {
        background: none;
    }
</style>
@endsection

@section('content')

    @isset($data['page'])
        <header class="hero position-relative text-white">
            <img class="hero-bg" src="{{ asset($data['page']->base_img) }}" alt="">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-2">
                <div class="hero-content">
                    <h1 class="display-5 fw-black mb-3">{{ $data['page']->title }}</h1>
                    <p class="lead opacity-90">{{ $data['page']->info }}</p>
                </div>
            </div>
        </header>
    @endisset

    @isset($data['page']->values)
        <section id="services" class="section section-cream">
            <div class="container">
                <h2 class="section-title">خدمتنا</h2>

                <div class="row g-3 services-grid">
                    @foreach ($data['page']->values as $value)
                    <div class="col-12 col-lg-4">
                        <article class="service-card is-bordered h-100">
                            <img class="service-img" src="{{ $value->img }}" alt="{{ $value->title }}">
                            <div class="service-body">
                                <h5 class="service-title">{{ $value->title }}</h5>
                                <p class="service-text">{{ $value->comment }}</p>
                            </div>
                        </article>
                    </div>
                    @endforeach
                </div>

            </div>
        </section>
    @endisset

@endsection

<!-- custom js -->
@section('script')
<script>
    $(document).ready(function() {
        $('.stat-box').each(function(i) {
            setTimeout(() => {
                $(this).addClass('show');
            }, i * 200);
        });
    });
</script>
@endsection
