<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group([ 'namespace' => 'App\Http\Controllers\Admin', 'prefix' => 'admin-panel' ], function(){
        
    // login routes
    Route::get('/', 'AuthController@login'); 
    Route::get('login', 'AuthController@login')->name('admin/login');
    Route::post('login', 'AuthController@check_login')->name('admin/check-login');
    
    Route::group(['middleware' => ['adminLogin', 'limitReq']],function(){

        Route::get('get/targetCrud', 'HomeController@targetCrud')->name('get/targetCrud');
        
        Route::get('/home', 'HomeController@home')->name('admin/index');
        Route::get('logout', 'AuthController@logout')->name('admin/logout');
        
        Route::post('/store/client', 'HomeController@storeClient')->name('admin/store/client');
        Route::get('/export/clients', 'HomeController@exportClients')->name('admin/export/clients');
        Route::post('/import/clients', 'HomeController@importClients')->name('admin/import/clients');

        // admin routes
        Route::get('admins/info', 'AdminController@info')->name('admin/admins/info');
        Route::post('admins/info-update', 'AdminController@info_update')->name('admin/admins/info-update');
        Route::post('admins/change-password', 'AdminController@change_password')->name('admin/admins/change-password');
        
        Route::get('admins/index/{offset?}/{limit?}', 'AdminController@index')->name('admin/admins/index');
        Route::get('admins/create', 'AdminController@create')->name('admin/admins/create');
        Route::post('admins/create', 'AdminController@store')->name('admin/admins/store');
        Route::get('admins/activate', 'AdminController@activate')->name('admin/admins/activate');
        Route::get('admins/delete', 'AdminController@delete')->name('admin/admins/delete');
        Route::post('admins/pagination/{offset?}/{limit?}', 'AdminController@pagination')->name('admin/admins/pagination');
        Route::post('admins/search', 'AdminController@search')->name('admin/admins/search');
        Route::post('admins/search/byColumn', 'AdminController@searchByColumn')->name('admin/admins/search/byColumn'); 
        Route::get('admins/archives/{offset?}/{limit?}', 'AdminController@archives')->name('admin/admins/archives');
        Route::get('admins/back', 'AdminController@back')->name('admin/admins/back');
        Route::post('admins/pagination/archives/{offset?}/{limit?}', 'AdminController@archivesPagination')->name('admin/admins/pagination/archives');
        Route::post('admins/search/archives', 'AdminController@archivesSearch')->name('admin/admins/search/archives');
        Route::post('admins/search/byColumn/archives', 'AdminController@archivesSearchByColumn')->name('admin/admins/search/byColumn/archives');

        
      	    
        // page routes
        Route::get('pages/index/{offset?}/{limit?}', 'PageController@index')->name('admin/pages/index');
        Route::get('pages/create', 'PageController@create')->name('admin/pages/create');
        Route::post('pages/create', 'PageController@store')->name('admin/pages/store');
        Route::get('pages/edit/{id?}', 'PageController@edit')->name('admin/pages/edit');
        Route::post('pages/edit/{id}', 'PageController@update')->name('admin/pages/update');
        Route::get('pages/activate', 'PageController@activate')->name('admin/pages/activate');
        Route::get('pages/delete', 'PageController@delete')->name('admin/pages/delete');
        Route::post('pages/pagination/{offset?}/{limit?}', 'PageController@pagination')->name('admin/pages/pagination');
        Route::post('pages/search', 'PageController@search')->name('admin/pages/search');
        Route::post('pages/search/byColumn', 'PageController@searchByColumn')->name('admin/pages/search/byColumn');
        Route::get('pages/archives/{offset?}/{limit?}', 'PageController@archives')->name('admin/pages/archives');
        Route::get('pages/back', 'PageController@back')->name('admin/pages/back');
        Route::post('pages/pagination/archives/{offset?}/{limit?}', 'PageController@archivesPagination')->name('admin/pages/pagination/archives');
        Route::post('pages/search/archives', 'PageController@archivesSearch')->name('admin/pages/search/archives');
        Route::post('pages/search/byColumn/archives', 'PageController@archivesSearchByColumn')->name('admin/pages/search/byColumn/archives');
        Route::get('pages/screens/{pageNo}', 'PageController@screens')->name('admin/pages/screens');
        Route::get('pages/remove/rating/{id}', 'PageController@removeRating')->name('admin/pages/remove/rating'); 
        Route::get('pages/remove/partners/{id}', 'PageController@removePartners')->name('admin/pages/remove/partners');
        Route::get('pages/requests', 'PageController@requests')->name('admin/pages/requests');
        Route::post('pages/services/update/{id?}', 'PageController@servicesUpdate')->name('admin/pages/services/update');
        Route::get('pages/services/delete/{id?}', 'PageController@servicesDelete')->name('admin/pages/services/delete');
        Route::get('pages/contacts', 'PageController@contacts')->name('admin/pages/contacts');

        
          
        // offer routes
        Route::get('offers/index/{offset?}/{limit?}', 'OfferController@index')->name('admin/offers/index');
        Route::get('offers/create', 'OfferController@create')->name('admin/offers/create');
        Route::post('offers/create', 'OfferController@store')->name('admin/offers/store');
        Route::get('offers/edit/{id?}', 'OfferController@edit')->name('admin/offers/edit');
        Route::post('offers/edit/{id}', 'OfferController@update')->name('admin/offers/update');
        Route::post('offers/custom/edit/{id}', 'OfferController@customUpdate')->name('admin/offers/custom/update');
        Route::post('offers/delete/img/{id?}', 'OfferController@deleteImg')->name('admin/offers/delete/img');
        Route::get('offers/details/{id?}', 'OfferController@details')->name('admin/offers/details');
        Route::post('offers/store/details/{id?}', 'OfferController@storeDetails')->name('admin/offers/store/details');
        Route::post('offers/update/details/{id?}', 'OfferController@updateDetails')->name('admin/offers/update/details');
        Route::post('offers/delete/details/{id?}', 'OfferController@deleteDetails')->name('admin/offers/delete/details');
        Route::get('offers/activate', 'OfferController@activate')->name('admin/offers/activate');
        Route::get('offers/delete', 'OfferController@delete')->name('admin/offers/delete');
        Route::get('offers/delete/custom/{id?}', 'OfferController@customDelete')->name('admin/offers/delete/custom');
        Route::post('offers/pagination/{offset?}/{limit?}', 'OfferController@pagination')->name('admin/offers/pagination');
        Route::post('offers/search', 'OfferController@search')->name('admin/offers/search');
        Route::post('offers/search/byColumn', 'OfferController@searchByColumn')->name('admin/offers/search/byColumn');
        Route::get('offers/archives/{offset?}/{limit?}', 'OfferController@archives')->name('admin/offers/archives');
        Route::get('offers/back', 'OfferController@back')->name('admin/offers/back');
        Route::post('offers/pagination/archives/{offset?}/{limit?}', 'OfferController@archivesPagination')->name('admin/offers/pagination/archives');
        Route::post('offers/search/archives', 'OfferController@archivesSearch')->name('admin/offers/search/archives');
        Route::post('offers/search/byColumn/archives', 'OfferController@archivesSearchByColumn')->name('admin/offers/search/byColumn/archives');

        
      //ROUTEFROMCOMMANDLINE

    });
});
