<!-- title page -->
<?php $__env->startSection('title'); ?>
    <title>نوع المساكن</title>
<?php $__env->stopSection(); ?>

<!-- custom page -->
<?php $__env->startSection('css'); ?>
<style>
    .nearby-card {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 10px 15px;
        border-radius: 8px;
        background: #f5f5ff;
    }
    .nearby-ico {
        background: #e6e6ff;
        color: #3c3c8c;
        border-radius: 50%;
        padding: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .nearby-text {
        flex: 1;
        text-align: right;
    }
    .carousel-item img, .carousel-item video {
        width: 100%;
        height: 500px;
        object-fit: cover;
        border-radius: 8px;
    }
    .carousel-control-prev-icon, .carousel-control-next-icon {
        background-image: none !important;
    }
    .custom-carousel-icon {
        width: 45px;
        height: 45px;
        background-color: rgba(0, 0, 0, 0.4); 
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .carousel-control-prev-icon::after {
        content: "‹"; 
        font-size: 28px;
        color: #fff;
        font-weight: bold;
    }
    .carousel-control-next-icon::after {
        content: "›"; 
        font-size: 28px;
        color: #fff;
        font-weight: bold;
    }
    .custom-carousel-icon:hover {
        background-color: rgba(0, 0, 0, 0.7);
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php if(isset($data['page'])): ?>
        <header class="hero position-relative text-white">
            <img class="hero-bg" src="<?php echo e(asset($data['page']->base_img)); ?>" alt="">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-2">
                <div class="hero-content">
                    <h1 class="display-5 fw-black mb-3"><?php echo e($data['page']->title); ?></h1>
                    <p class="lead opacity-90"><?php echo e($data['page']->info); ?></p>
                </div>
            </div>
        </header>
    <?php endif; ?>

    <?php if(isset($data['offer'])): ?>
        <section id="property-details" class="section section-cream">
            <div class="container">

                <section class="section section-cream" style="padding-top: 26px !important;">
                    <div class="container">
                        <h3 class="section-subtitle">تفاصيل العقار</h3>

                        <div class="row g-3">
                            
                            <?php if(isset($data['offer']->details)): ?>
                                <?php $__currentLoopData = $data['offer']->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $backgroundColor = '';
                                        if ($detail->offer_status === 'متاح') {
                                            $backgroundColor = 'background: #eaf7ef; color: #1f7a42; padding: 4px 7px; border-radius: 10px;';
                                        }elseif ($detail->offer_status === 'مباع') {
                                            $backgroundColor = 'background: #ffe8e8; color: #a01a1a; padding: 4px 7px; border-radius: 10px;';
                                        }elseif ($detail->offer_status === 'محجوز') {
                                            $backgroundColor = 'background: #fff4e6; color: #a35600; padding: 4px 7px; border-radius: 10px;';
                                        }
                                    ?>
                                    <div class="col-12 col-md-6 col-lg-3">
                                        <div class="new-mini-card">
                                            <div class="new-mini-top">
                                                <span class="new-mini-badge is-available" style="<?php echo e($backgroundColor); ?>"><?php echo e($detail->offer_status); ?></span>
                                                <span class="new-mini-meta">رقم العرض: <b><?php echo e($detail->offer_number); ?></b></span>
                                            </div>
                                            <button href="#" class="new-mini-cta" data-bs-toggle="modal" data-bs-target="#exampleModal-<?php echo e($detail->id); ?>">شاهد التفاصيل</button>
                                            <div class="modal fade" id="exampleModal-<?php echo e($detail->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">

                                                            <div class="new-md-sheet">

                                                                <div class="new-md-headline" dir="ltr">
                                                                    <div class="d-flex align-items-center gap-2">
                                                                        <span class="badge new-ok new-md-status" style="<?php echo e($backgroundColor); ?>"><?php echo e($detail->offer_status); ?></span>
                                                                    </div>
                                                                    <h5 class="new-md-offer m-0">
                                                                        <span class="text-muted">رقم العرض:</span>
                                                                        <b><?php echo e($detail->offer_number); ?></b>
                                                                    </h5>
                                                                </div>
                                                                <div class="new-md-table">

                                                                    <div class="new-md-row">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-building"></i> الدور
                                                                        </div>
                                                                        <div class="new-md-val"><?php echo e($detail->floor); ?></div>
                                                                    </div>
                                                                    <div class="new-md-row">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-aspect-ratio"></i> المساحة
                                                                        </div>
                                                                        <div class="new-md-val"><b><?php echo e($detail->area); ?></b><sup></sup></div>
                                                                    </div>
                                                                    <div class="new-md-row">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-door-open"></i> الغرف
                                                                        </div>
                                                                        <div class="new-md-val"><?php echo e($detail->rooms_count); ?></div>
                                                                    </div>
                                                                    <div class="new-md-row">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-compass"></i> الواجهة
                                                                        </div>
                                                                        <div class="new-md-val"><?php echo e($detail->front); ?></div>
                                                                    </div>
                                                                    <div class="new-md-row is-accent">
                                                                        <div class="new-md-key">
                                                                            <i class="bi bi-cash-coin"></i> السعر
                                                                        </div>
                                                                        <div class="new-md-val new-md-price">
                                                                            <span class="new-md-price-num"><?php echo e($detail->price); ?></span>
                                                                            <span class="new-md-price-cur">ر.س</span>
                                                                        </div>
                                                                    </div>

                                                                </div>

                                                                <div class="new-md-note small text-muted">
                                                                    آخر تحديث: امس 12:30 م
                                                                </div>
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                            <!-- <button type="button" class="btn btn-primary">Save changes</button> -->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                        </div>
                    </div>
                </section>

                <h3 class="section-subtitle">معلومات المشروع</h3>
                <div class="info-table mb-5">
                    <?php if(!is_null($data['offer']->pro_info_offer_number) && !empty($data['offer']->pro_info_offer_number)): ?>
                        <div class="info-row">
                            <div class="info-key">رقم الرخصة</div>
                            <div class="info-val"><?php echo e($data['offer']->pro_info_offer_number); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if(!is_null($data['offer']->pro_info_city) && !empty($data['offer']->pro_info_city)): ?>
                        <div class="info-row">
                            <div class="info-key">المدينة</div>
                            <div class="info-val"><?php echo e($data['offer']->pro_info_city); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if(!is_null($data['offer']->pro_info_region) && !empty($data['offer']->pro_info_region)): ?>
                        <div class="info-row">
                            <div class="info-key">الحي</div>
                            <div class="info-val"><?php echo e($data['offer']->pro_info_region); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if(!is_null($data['offer']->pro_info_details) && !empty($data['offer']->pro_info_details)): ?>
                        <div class="info-row">
                            <div class="info-key">الوصف</div>
                            <div class="info-val"><?php echo e($data['offer']->pro_info_details); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if(!is_null($data['offer']->pro_info_rooms_count) && !empty($data['offer']->pro_info_rooms_count)): ?>
                        <div class="info-row">
                            <div class="info-key">الغرف</div>
                            <div class="info-val"><?php echo e($data['offer']->pro_info_rooms_count); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if(!is_null($data['offer']->pro_info_floor) && !empty($data['offer']->pro_info_floor)): ?>
                        <div class="info-row">
                            <div class="info-key">الطوابق</div>
                            <div class="info-val"><?php echo e($data['offer']->pro_info_floor); ?></div>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if(isset($data['offer']->nears_from)): ?>
                    <h3 class="section-subtitle">بالقرب من</h3>
                    <div class="row g-2 g-md-3">

                        <?php $__currentLoopData = explode(',', $data['offer']->nears_from); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12 col-md-4">
                                <a class="nearby-card d-flex align-items-center justify-content-between" href="#">
                                    <span class="nearby-ico">
                                        <i class="bi bi-geo-alt"></i>
                                    </span>
                                    <span class="nearby-text"><?php echo e($date); ?></span>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                <?php endif; ?>

            </div>
        </section>

        <section class="section section-cream">
            <div class="container">

            <?php if(isset($data['offer']->features)): ?>
                <h3 class="section-subtitle">مميزات المشروع</h3>
                <div class="row g-2 g-md-3 features-grid mb-4">
                
                    <?php $__currentLoopData = explode(',', $data['offer']->features); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-6 col-lg-3">
                            <div class="chip-feature"><i class="bi bi-check2-circle"></i> <?php echo e($date); ?></div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            <?php if(isset($data['offer']->guarantees)): ?>
                <h3 class="section-subtitle mt-5">الضمانات</h3>
                <div class="row g-3 mb-4 guarantees-grid">
                    <?php $__currentLoopData = json_decode($data['offer']->guarantees); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-6 col-xl-3">
                            <div class="guarantee-item">
                                <div class="g-badge">
                                    <div class="g-num"><?php echo e($date->years); ?> <br><span class="g-unit">سنوات</span></div>
                                </div>
                                <div class="g-title"><?php echo e($date->content); ?></div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            <?php if(isset($data['offer']->media)): ?>
                <h3 class="section-subtitle mt-5">الصور والفيديو</h3>
                <div class="gallery-card">
                    <div id="mediaCarousel" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            <?php $__currentLoopData = $data['offer']->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="carousel-item <?php echo e($loop->last ? 'active' : ''); ?>">
                                    <?php
                                        $ext = pathinfo($file->img, PATHINFO_EXTENSION);
                                    ?>
                                    <?php if(in_array(strtolower($ext), ['jpg','jpeg','png','gif','webp','svg'])): ?>
                                        <img src="<?php echo e(asset($file->img)); ?>" class="d-block w-100 gallery-img mx-auto" alt="">
                                    <?php elseif(in_array(strtolower($ext), ['mp4','mov','avi','wmv','mkv'])): ?>
                                        <video controls>
                                            <source src="<?php echo e(asset($file->img)); ?>" type="video/<?php echo e($ext); ?>">
                                            متصفحك لا يدعم تشغيل الفيديو
                                        </video>
                                    <?php endif; ?>
                                    
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#mediaCarousel" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon custom-carousel-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#mediaCarousel" data-bs-slide="next">
                            <span class="carousel-control-next-icon custom-carousel-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            </div>
        </section>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<!-- custom js -->
<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            $('.stat-box').each(function(i) {
                setTimeout(() => {
                    $(this).addClass('show');
                }, i * 200);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.website.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\htre-mvc\resources\views/website/offer_details.blade.php ENDPATH**/ ?>