<!-- title page -->
<?php $__env->startSection('title'); ?>
    <title>Admins</title>
<?php $__env->stopSection(); ?>

<!-- custom page -->
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="profile-page" lang="ar" dir="rtl" aria-labelledby="profile-page-title">
        <header class="profile-page-head">
            <h2 id="profile-page-title" class="profile-page-title">الإعدادات</h2>
        </header>

        <form id="profile-page-form" class="profile-page-form" novalidate action="<?php echo e(url(route('admin/admins/info-update'))); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="profile-page-card">
                <div class="error-area" style="text-align: center;">
                    <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php if($errors->any()): ?>
                        <div style="text-align: left; margin: 15px; color: red;">
                            <ul dir="ltr">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="text-danger"><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
                <label class="profile-page-field">
                    <span class="profile-page-label">الاسم</span>
                    <input class="profile-page-input" name="name" type="text" value="<?php echo e(auth()->guard('admin')->user()->name); ?>" placeholder="أدخل اسمك" />
                </label>
                <label class="profile-page-field">
                    <span class="profile-page-label">تعديل الرقم السري</span>
                    <div class="profile-page-passwrap">
                        <input class="profile-page-input" id="profile-page-pass" name="password" type="password" placeholder="******" />
                        <button class="profile-page-eye" type="button" data-target="profile-page-pass" aria-label="إظهار/إخفاء">👁️</button>
                    </div>
                </label>
                <label class="profile-page-field">
                    <span class="profile-page-label">تأكيد تعديل الرقم السري</span>
                    <div class="profile-page-passwrap">
                        <input class="profile-page-input" id="profile-page-pass2" name="password_confirmation" type="password" placeholder="******" />
                        <button class="profile-page-eye" type="button" data-target="profile-page-pass2" aria-label="إظهار/إخفاء">👁️</button>
                    </div>
                    <small class="profile-page-error" id="profile-page-error" hidden>كلمتا المرور غير متطابقتين.</small>
                </label>
                <label class="field">
                    <div>
                        <label class="home-form__upload">
                            <span class="home-form__upload-text">رفع الصورة</span>
                            <input type="file" name="file" accept="image/*">
                            <img class="upload__img" class="uploader-preview" src="" style="max-height:300px;width:100%;object-fit:cover;border-radius:12px">
                        </label>
                    </div>
                </label>
                <div class="profile-page-actions">
                    <button class="profile-page-btn" type="submit">حفظ التغييرات</button>
                </div>
            </div>
        </form>
    </section>
<?php $__env->stopSection(); ?>

<!-- custom js -->
<?php $__env->startSection('script'); ?>
    <script>
        (function profilePageInit() {
        
            $("#settings").addClass('active');
            // const form = document.getElementById('profile-page-form');
            const err = document.getElementById('profile-page-error');

            document.querySelectorAll('.profile-page-eye').forEach(btn => {
                btn.addEventListener('click', () => {
                    const id = btn.getAttribute('data-target');
                    const input = document.getElementById(id);
                    input.type = input.type === 'password' ? 'text' : 'password';
                });
            });
            document.addEventListener('change', function(e) {
                console.log(121212122);
                
                const t = e.target;
                if (!(t instanceof HTMLInputElement)) return;
                if (t.type !== 'file') return;

                if (t.name === 'file' || t.name === 'statistic_img') {
                    return previewSingle(t);
                }

            });
            function previewSingle(input) {
                const file = input.files && input.files[0];
                const box = input.closest('label')
                if (!file || !box) return;
                let img = box.querySelector('.upload__img');
                if (!img) {
                    img = document.createElement('img');
                    img.className = 'upload__img';
                    box.appendChild(img);
                }
                img.src = URL.createObjectURL(file);
                box.classList.add('has-image');
            }

            // form.addEventListener('submit', (e) => {
            //     e.preventDefault();
            //     const data = Object.fromEntries(new FormData(form).entries());
            //     const pass = data.password?.trim();
            //     const conf = data.confirm?.trim();

            //     const wantsChange = pass || conf;

            //     if (wantsChange && pass !== conf) {
            //         err.hidden = false;
            //         return;
            //     }
            //     err.hidden = true;

            //     // fetch('/api/profile', {method:'POST', body:new FormData(form)})
            //     alert('تم حفظ التغييرات (ديمو).');
            // });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\htre-mvc\resources\views/admin/admins/info.blade.php ENDPATH**/ ?>