<!-- title page -->
<?php $__env->startSection('title'); ?>
    <title>نوع المساكن</title>
<?php $__env->stopSection(); ?>

<!-- custom page -->
<?php $__env->startSection('css'); ?>
<style>
    .stat-box {
        background: #fff;
        border-radius: 15px;
        padding: 20px;
        box-shadow: 0 10px 10px rgba(0,0,0,0.05);
        opacity: 0;
        transform: scale(0.9);
        transition: all 0.5s ease-in-out;
    }
    .stat-box.show {
        opacity: 1;
        transform: scale(1);
    }
    .stat-box:hover {
        transform: translateY(-5px) scale(1.03);
        box-shadow: 0 6px 15px rgba(0,0,0,0.1);
    }
    .card-img-top {
        width: 100%;
        height: 250px;
        object-fit: cover;
        border-radius: 8px;  
    }
    .partner-logo {
        max-width: 140px;
        max-height: 100px;
        object-fit: contain;
        filter: grayscale(100%);
        transition: 0.3s;
        margin: 0px 25px;
    }
    .partner-logo:hover {
        filter: grayscale(0%);
        transform: scale(1.05);
    }
    .carousel-control-prev-icon, .carousel-control-next-icon {
        background-image: none !important;
        background-color: #303030 !important;
        padding: 25px !important;
    }
    .custom-carousel-icon {
        width: 45px;
        height: 45px;
        background-color: rgba(0, 0, 0, 0.4); 
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .carousel-control-prev-icon::after {
        content: "‹";  
        font-size: 28px;
        color: #fff;
        font-weight: bold;
    }
    .carousel-control-next-icon::after {
        content: "›"; 
        font-size: 28px;
        color: #fff;
        font-weight: bold;
    }
    .custom-carousel-icon:hover {
        background-color: rgba(0, 0, 0, 0.7);
    }
    #partnersCarouselRatinf {
        margin-bottom: 8% !important;
    }
    .carousel-control-next-icon, .carousel-control-prev-icon {
        height: 6rem !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php if(isset($data['page'])): ?>
        <header class="hero position-relative text-white">
            <img class="hero-bg" src="<?php echo e(asset($data['page']->base_img)); ?>" alt="">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-2">
                <div class="hero-content">
                    <h1 class="display-5 fw-black mb-3"><?php echo e($data['page']->title); ?></h1>
                    <p class="lead opacity-90"><?php echo e($data['page']->info); ?></p>
                </div>
            </div>
        </header>
    <?php endif; ?>

    <?php if(isset($data['realestate'])): ?>
        <section class="section-padding bg-cream">
            <div class="container">
                <h2 class="section-title">أحدث العروض العقارية</h2>

                <div id="offersCarousel" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">

                        <?php $__currentLoopData = $data['realestate']->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="carousel-item <?php echo e($loop->first ? 'active' : ''); ?>">
                                <div class="row g-3">
                                    <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $realestate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <article class="property-card card h-100 shadow-sm">
                                                <div class="position-relative overflow-hidden">
                                                    <a href="<?php echo e(url(route('website/details/offer', $realestate->id))); ?>" class="prop-title">
                                                        <img class="card-img-top" src="<?php echo e(asset($realestate->img)); ?>" alt="عقار">
                                                    </a>
                                                    <?php
                                                        $backgroundColor = '';
                                                        if ($realestate->status === 'متاح') {
                                                            $backgroundColor = 'background: #eaf7ef; color: #1f7a42; padding: 4px 7px; border-radius: 10px;';
                                                        }elseif ($realestate->status === 'مباع') {
                                                            $backgroundColor = 'background: #ffe8e8; color: #a01a1a; padding: 4px 7px; border-radius: 10px;';
                                                        }elseif ($realestate->status === 'محجوز') {
                                                            $backgroundColor = 'background: #fff4e6; color: #a35600; padding: 4px 7px; border-radius: 10px;';
                                                        }
                                                    ?>
                                                    <span class="<?php if(empty($backgroundColor)): ?> badge bg-primary <?php endif; ?> position-absolute top-0 start-0 m-2" style="<?php echo e($backgroundColor); ?>"><?php echo e($realestate->status); ?></span>
                                                </div>
                                                <div class="card-body">
                                                    
                                                    <a href="<?php echo e(url(route('website/details/offer', $realestate->id))); ?>" class="prop-title"><?php echo e($realestate->title); ?></a>
                                                    <div class="price">ر.س <span><?php echo e($realestate->price); ?></span></div>
                                                    <ul class="icon-specs list-unstyled d-flex flex-wrap gap-3 mt-3">
                                                        <li><i class="bi bi-house-door"></i> <?php echo e($realestate->rooms_count); ?> غرف</li>
                                                        <li><i class="bi bi-droplet"></i> <?php echo e($realestate->bathrooms_count); ?> دورات مياه</li>
                                                        <li><i class="bi bi-aspect-ratio"></i> <?php echo e($realestate->area); ?></li>
                                                        <li><i class="bi bi-car-front"></i> <?php echo e($realestate->parking_count); ?> <?php echo e($realestate->parking_count > 2 ? 'مواقف' : 'موقف'); ?></li>
                                                    </ul>
                                                </div>
                                            </article>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                    <button class="carousel-control-prev" type="button" data-bs-target="#offersCarousel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">السابق</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#offersCarousel" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">التالي</span>
                    </button>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if(isset($data['exclusive'])): ?>
        <section class="section-padding"> 
            <div class="container">
                <h2 class="section-title">المشاريع الحصرية</h2>

                <div id="projectsCarousel" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                    
                        <?php $__currentLoopData = $data['exclusive']->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="carousel-item <?php echo e($loop->first ? 'active' : ''); ?>">
                                <div class="row g-3">
                                    <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $realestate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <article class="property-card card h-100 shadow-sm">
                                                <div class="position-relative overflow-hidden">
                                                    <a href="<?php echo e(url(route('website/details/offer', $realestate->id))); ?>" class="prop-title">
                                                        <img class="card-img-top" src="<?php echo e(asset($realestate->img)); ?>" alt="عقار">
                                                    </a>
                                                    <?php
                                                        $backgroundColor = '';
                                                        if ($realestate->status === 'متاح') {
                                                            $backgroundColor = 'background: #eaf7ef; color: #1f7a42; padding: 4px 7px; border-radius: 10px;';
                                                        }elseif ($realestate->status === 'مباع') {
                                                            $backgroundColor = 'background: #ffe8e8; color: #a01a1a; padding: 4px 7px; border-radius: 10px;';
                                                        }elseif ($realestate->status === 'محجوز') {
                                                            $backgroundColor = 'background: #fff4e6; color: #a35600; padding: 4px 7px; border-radius: 10px;';
                                                        }
                                                    ?>
                                                    <span class="<?php if(empty($backgroundColor)): ?> badge bg-primary <?php endif; ?> position-absolute top-0 start-0 m-2" style="<?php echo e($backgroundColor); ?>"><?php echo e($realestate->status); ?></span>
                                                </div>
                                                <div class="card-body">
                                                    
                                                    <a href="<?php echo e(url(route('website/details/offer', $realestate->id))); ?>" class="prop-title"><?php echo e($realestate->title); ?></a>
                                                    <div class="price">ر.س <span><?php echo e($realestate->price); ?></span></div>
                                                    <ul class="icon-specs list-unstyled d-flex flex-wrap gap-3 mt-3">
                                                        <li><i class="bi bi-house-door"></i> <?php echo e($realestate->rooms_count); ?> غرف</li>
                                                        <li><i class="bi bi-droplet"></i> <?php echo e($realestate->bathrooms_count); ?> دورات مياه</li>
                                                        <li><i class="bi bi-aspect-ratio"></i> <?php echo e($realestate->area); ?></li>
                                                        <li><i class="bi bi-car-front"></i> <?php echo e($realestate->parking_count); ?> <?php echo e($realestate->parking_count > 2 ? 'مواقف' : 'موقف'); ?></li>
                                                    </ul>
                                                </div>
                                            </article>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                    <button class="carousel-control-prev" type="button" data-bs-target="#projectsCarousel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">السابق</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#projectsCarousel" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">التالي</span>
                    </button>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if(isset($data['page']->statistics)): ?>
        <section class="section-padding bg-cream">
            <div class="container">
                <h2 class="section-title">أرقامنا</h2>
                <div class="row g-3">

                    
                    <?php $__currentLoopData = json_decode($data['page']->statistics); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-6 col-lg-4">
                            <div class="stat-box">
                                
                                <div class="stat-value"><?php echo e($date->title); ?></div>
                                <div class="stat-text"><?php echo e($date->content); ?></div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    

                    
                </div>
            </div>
        </section>
    <?php endif; ?>

   

    <?php if(isset($data['ratings']) || isset($data['partners'])): ?>
        <section id="ratings-partners-section" class="section-padding">
            <div class="container">
                <?php if(isset($data['ratings'])): ?>
                    <h2 class="section-title">تقييمات العملاء</h2>
                    <div id="partnersCarouselRatinf" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            <?php $__currentLoopData = $data['ratings']->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="carousel-item <?php echo e($index == 0 ? 'active' : ''); ?>">
                                <div class="d-flex justify-content-center gap-3">
                                    <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rating): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <div class="card shadow-sm h-100">
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center gap-2 mb-2">
                                                        <img src="<?php echo e(asset($rating->img)); ?>" alt="" class="rounded-circle" width="44" height="44">
                                                        <div>
                                                            <div class="fw-semibold"><?php echo e($rating->title); ?></div>
                                                            <div class="small text-muted"><?php echo e($rating->rating_at); ?></div>
                                                        </div>
                                                    </div>
                                                    <p class="mb-2"><?php echo e($rating->content); ?></p>
                                                    <div class="rating" data-value="<?php echo e($rating->rating); ?>">
                                                        <?php for($forLoop = 1; $forLoop < 6; $forLoop++): ?>
                                                            <i class="bi <?php if($rating->rating >= $forLoop): ?> bi-star-fill <?php else: ?> bi-star <?php endif; ?>"></i>
                                                        <?php endfor; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <button class="carousel-control-prev" type="button" data-bs-target="#partnersCarouselRatinf" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon custom-carousel-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#partnersCarouselRatinf" data-bs-slide="next">
                            <span class="carousel-control-next-icon custom-carousel-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if(isset($data['partners'])): ?>
                    <div class="partners mt-5 mb-4">
                        <h2 class="section-title">شركاء النجاح</h2>
                        <div id="partnersCarouselPartners" class="carousel slide" data-bs-ride="carousel">
                            <div class="carousel-inner">
                                <?php $__currentLoopData = $data['partners']->chunk(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="carousel-item <?php echo e($index == 0 ? 'active' : ''); ?>">
                                    <div class="d-flex justify-content-center gap-3">
                                        <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <img src="<?php echo e(asset($partner->img)); ?>" class="d-block partner-logo" alt="partner">
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <button class="carousel-control-prev" type="button" data-bs-target="#partnersCarouselPartners" data-bs-slide="prev">
                                <span class="carousel-control-prev-icon custom-carousel-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Previous</span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#partnersCarouselPartners" data-bs-slide="next">
                                <span class="carousel-control-next-icon custom-carousel-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Next</span>
                            </button>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </section>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<!-- custom js -->
<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function() {
        $('.stat-box').each(function(i) {
            setTimeout(() => {
                $(this).addClass('show');
            }, i * 200);
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.website.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\htre-mvc\resources\views/website/home.blade.php ENDPATH**/ ?>