<!-- title page -->
<?php $__env->startSection('title'); ?>
    <title>Offers</title>
<?php $__env->stopSection(); ?>

<!-- custom css -->
<?php $__env->startSection('css'); ?>
<style>
    .image-row {
        display: flex;
        gap: 15px;
        margin: 20px 0;
    }
    .image-item {
        position: relative;
        width: 150px;
        height: 150px;
    }
    .image-item img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 8px;
        border: 1px solid #ccc;
    }
    .delete-btn {
        position: absolute;
        top: 5px;
        right: 5px;
        background: rgba(255, 0, 0, 0.7);
        border: none;
        color: #fff;
        border-radius: 50%;
        width: 24px;
        height: 24px;
        font-size: 14px;
        line-height: 20px;
        cursor: pointer;
        transition: 0.2s;
    }
    .delete-btn:hover {
        background: red;
    }
    .image-item {
        position: relative;
        width: 150px;   
        height: 150px;  
        border-radius: 8px;
        overflow: hidden;
        margin: 5px;
    }
    .image-item img, .image-item video {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 8px;
        display: block;
    }
    .delete-btn {
        position: absolute;
        top: 5px;
        right: 5px;
        background: rgba(255, 0, 0, 0.7);
        border: none;
        color: #fff;
        border-radius: 50%;
        width: 24px;
        height: 24px;
        font-size: 14px;
        line-height: 20px;
        cursor: pointer;
    }
    .delete-btn:hover {
        background: red;
    }
    .d-flex {
        display: flex;
        align-items: center;
    }
    .d-flex input {
        flex: 1;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="offer-details-page" lang="ar" dir="rtl" aria-labelledby="offer-details-page-title">
        <header class="offer-details-page-head">
            <h2 id="offer-details-page-title" class="offer-details-page-title">تفاصيل عروض العقارية</h2>
        </header>
        <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if($errors->any()): ?>
            <div style="text-align: left; margin: 15px;">
                <ul dir="ltr">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="text-danger"><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <header class="offer-details-page-head" dir="ltr">
            <button class="offer-details-page-btn offer-details-page-btn--primary" id="odp-add-unit" type="button">إضافة تفاصيل عقارية</button>
        </header>

        <section class="offer-details-page-section">
            <div id="odp-units" class="offer-details-page-units">
                <?php if(isset($offer->details)): ?>
                    <?php $__currentLoopData = $offer->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <article class="offer-details-page-unit" data-odp-unit>
                            
                            <form action="<?php echo e(url(route('admin/offers/delete/details', $detail->id))); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                
                                <input type="hidden" name="record_id" value="<?php echo e($detail->id); ?>">
                                <button type="submit" class="offer-details-page-unit__remove delete-data-btn">✕</button>
                            </form>
                            <div class="offer-details-page-unit__top">
                                <?php
                                    $backgroundColor = '';
                                    if ($detail->offer_status === 'متاح') {
                                        $backgroundColor = 'background: #eaf7ef; color: #1f7a42;';
                                    }elseif ($detail->offer_status === 'مباع') {
                                        $backgroundColor = 'background: #ffe8e8; color: #a01a1a;';
                                    }elseif ($detail->offer_status === 'محجوز') {
                                        $backgroundColor = 'background: #fff4e6; color: #a35600;';
                                    }
                                ?>
                                <span class="offer-details-page-badge" style="<?php echo e($backgroundColor); ?>" data-odp-state><?php echo e($detail->offer_status); ?></span>
                                <span class="offer-details-page-price" data-odp-price><?php echo e($detail->price); ?></span>
                            </div>
                            <div class="offer-details-page-unit__meta">
                                <span>رقم العرض: <b data-odp-code><?php echo e($detail->offer_number); ?></b></span>
                            </div>
                            <button class="offer-details-page-chip" target-model="offer-details-page-modal-<?php echo e($detail->id); ?>" data-action="edit" type="button">تعديل</button>
                        </article>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </section>

        <section class="offer-details-page-section">
            <div class="offer-details-page-section__head">
                <h3>تعديل معلومات المشروع</h3>
            </div>

            <form id="offer-details-page-info-form" class="offer-details-page-form" action="<?php echo e(url(route('admin/offers/custom/update', $offer->id))); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="offer-details-page-grid offer-details-page-grid--info">
                    <label class="offer-details-page-field">



                        <span class="offer-details-page-label">الوصف</span>
                        <input class="offer-details-page-input" name="pro_info_details" value="<?php echo e($offer->pro_info_details); ?>" type="text" value="1246" />
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">رقم العرض</span>
                        <input class="offer-details-page-input" name="pro_info_offer_number" value="<?php echo e($offer->pro_info_offer_number); ?>" type="text" value="1246" />
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">حالة العرض</span>
                        <select class="edit-offer-page-input" name="pro_info_status">
                            <option value="متاح" <?php echo e($offer->pro_info_status == 'متاح' ? 'selected' : ''); ?>>متاح</option>
                            <option value="محجوز" <?php echo e($offer->pro_info_status == 'محجوز' ? 'selected' : ''); ?>>محجوز</option>
                            <option value="مباع" <?php echo e($offer->pro_info_status == 'مباع' ? 'selected' : ''); ?>>مباع</option>
                        </select>
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">نوع العقار</span>
                        <select class="offer-details-page-input" name="pro_info_type">
                            <option <?php echo e($offer->pro_info_type == '1' ? 'selected' : ''); ?> value="1">شقة</option>
                            <option <?php echo e($offer->pro_info_type == '2' ? 'selected' : ''); ?> value="2">شقّة</option>
                            <option <?php echo e($offer->pro_info_type == '3' ? 'selected' : ''); ?> value="3">فيلا</option>
                            <option <?php echo e($offer->pro_info_type == '4' ? 'selected' : ''); ?> value="4">تاون هاوس</option>
                        </select>
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">المدينة</span>
                        <input class="edit-offer-page-input" name="pro_info_city" value="<?php echo e($offer->pro_info_city); ?>" type="text" placeholder="المدينة" />
                    </label>

                    <label class="offer-details-page-field">



                        <span class="offer-details-page-label">الحي</span>
                        <input class="edit-offer-page-input" name="pro_info_region" value="<?php echo e($offer->pro_info_region); ?>" type="text" placeholder="الحي" />
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">الغرف</span>
                        <input class="edit-offer-page-input" name="pro_info_rooms_count" value="<?php echo e($offer->pro_info_rooms_count); ?>" type="text" placeholder="عدد الغرف" />
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">المساحة (م²)</span>
                        <input class="edit-offer-page-input" name="pro_info_area" value="<?php echo e($offer->pro_info_area); ?>" type="text" placeholder="150 متر" />
                    </label>

                    <label class="offer-details-page-field">



                        <span class="offer-details-page-label">الطوابق</span>
                        <input class="edit-offer-page-input" name="pro_info_floor" value="<?php echo e($offer->pro_info_floor); ?>" type="text" placeholder="الطوابق" />
                    </label>
                </div>

                <div class="offer-details-page-actions">
                    <button class="offer-details-page-btn offer-details-page-btn--primary" type="submit">حفظ التغييرات</button>
                </div>
            </form>
        </section>

        <section class="offer-details-page-section">
            <div class="offer-details-page-cols">
                <div class="offer-details-page-col">

                    <form action="<?php echo e(url(route('admin/offers/custom/update', $offer->id))); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <h3 class="offer-details-page-subtitle">بالقرب من</h3>
                        <?php if(isset($offer->nears_from)): ?>
                            <?php $__currentLoopData = explode(',', $offer->nears_from); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="offer-details-page-textitem input-wrapper mb-2" data-odp-textitem>
                                    <input class="offer-details-page-input" name="nears_from[]" value="<?php echo e($date); ?>" type="text" placeholder="مستشفى/مول/الحي..." />
                                    <button class="offer-details-page-remove" type="button" aria-label="حذف">✕</button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <div id="odp-nearby" class="offer-details-page-stack"></div>
                        <div class="offer-details-page-actions">
                            <button id="odp-add-nearby" class="offer-details-page-add" type="button">+</button>
                        </div>
                        <div class="offer-details-page-actions"><button class="offer-details-page-btn" type="submit" data-save="nearby">حفظ التغييرات</button></div>
                    </form>
                </div>

                <div class="offer-details-page-col">
                    <form action="<?php echo e(url(route('admin/offers/custom/update', $offer->id))); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <h3 class="offer-details-page-subtitle">مميزات المشروع</h3>
                        <?php if(isset($offer->features)): ?>
                            <?php $__currentLoopData = explode(',', $offer->features); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="offer-details-page-textitem input-wrapper mb-2" data-odp-textitem>
                                    <input class="offer-details-page-input" name="features[]" value="<?php echo e($date); ?>" type="text" placeholder="مستشفى/مول/الحي..." />
                                    <button class="offer-details-page-remove" type="button" aria-label="حذف">✕</button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <div id="odp-features" class="offer-details-page-stack"></div>
                        <div class="offer-details-page-actions">
                            <button id="odp-add-feature" class="offer-details-page-add" type="button">+</button>
                        </div>
                        <div class="offer-details-page-actions"><button class="offer-details-page-btn" type="submit" data-save="features">حفظ التغييرات</button></div>
                    </form>
                </div>
            </div>
        </section>

        <section class="offer-details-page-section">
            <div class="offer-details-page-cols">
                <div class="offer-details-page-col">
                    <form action="<?php echo e(url(route('admin/offers/custom/update', $offer->id))); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <h3 class="offer-details-page-subtitle">الضمانات</h3>
                        <?php if(isset($offer->guarantees)): ?>
                            <?php $lenghtData = 1; ?>
                            <?php $__currentLoopData = json_decode($offer->guarantees); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $lenghtData += 1; ?>
                                <div class="offer-details-page-textitem input-wrapper mb-2 d-flex" data-odp-textitem>
                                    
                                    <input class="offer-details-page-input" name="guarantees[<?php echo e($lenghtData); ?>][years]" value="<?php echo e($date->years); ?>" type="text" placeholder="years" />
                                    <input class="offer-details-page-input" name="guarantees[<?php echo e($lenghtData); ?>][content]" value="<?php echo e($date->content); ?>" type="text" placeholder="content" />
                                    <button class="offer-details-page-remove" type="button" aria-label="حذف">✕</button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <div id="odp-guarantees" class="offer-details-page-stack"></div>
                        <div class="offer-details-page-actions">
                            <button id="odp-add-amenity" class="offer-details-page-add" type="button">+</button>
                        </div>
                        <div class="offer-details-page-actions"><button class="offer-details-page-btn" type="submit" data-save="guarantees">حفظ التغييرات</button></div>
                    </form>
                </div>

                <div class="offer-details-page-col">
                    <h3 class="offer-details-page-subtitle">رفع الصور/الفيديوهات</h3>
                    <?php if(isset($offer->media)): ?>
                        <div class="image-row">
                            <?php $__currentLoopData = $offer->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <form action="<?php echo e(url(route('admin/offers/delete/img', $file->id))); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="image-item">
                                        
                                        
                                        <?php
                                            $ext = pathinfo($file->img, PATHINFO_EXTENSION);
                                        ?>
                                        <?php if(in_array(strtolower($ext), ['jpg','jpeg','png','gif','webp','svg'])): ?>
                                            <img src="<?php echo e(asset($file->img)); ?>" alt="image">
                                        <?php elseif(in_array(strtolower($ext), ['mp4','mov','avi','wmv','mkv'])): ?>
                                            <video controls>
                                                <source src="<?php echo e(asset($file->img)); ?>" type="video/<?php echo e($ext); ?>">
                                                متصفحك لا يدعم تشغيل الفيديو
                                            </video>
                                        <?php endif; ?>
                                        <input type="hidden" name="file_id" value="<?php echo e($file->id); ?>">
                                        <button type="submit" class="delete-btn delete-data-btn">✕</button>

                                    </form>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                    <form action="<?php echo e(url(route('admin/offers/custom/update', $offer->id))); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div id="odp-media" class="offer-details-page-media-grid"></div>
                        <div class="offer-details-page-actions">
                            <button id="odp-add-media" class="offer-details-page-add" type="button">+</button>
                        </div>
                        <div class="offer-details-page-actions"><button class="offer-details-page-btn" type="submit" data-save="media">حفظ التغييرات</button></div>
                    </form>
                </div>
            </div>
        </section>

    </section>
    <div id="offer-details-page-modal" class="offer-details-page-modal" role="dialog" aria-modal="true" aria-labelledby="offer-details-page-modal-title" hidden>
        <div class="offer-details-page-modal__backdrop" data-odp-close="true"></div>

        <div class="offer-details-page-modal__card" role="document">
            <header class="offer-details-page-modal__head">
                <h3 id="offer-details-page-modal-title" class="offer-details-page-modal__title">إضافة تفاصيل عقارية</h3>
                <button class="offer-details-page-modal__close" type="button" aria-label="إغلاق" data-odp-close="true">×</button>
            </header>

            <form id="offer-details-page-modal-form" class="offer-details-page-modal__form" action="<?php echo e(url(route('admin/offers/store/details', $offer->id))); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="offer-details-page-modal__grid">
                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">رقم العرض</span>
                        <input class="offer-details-page-input" name="offer_number" type="text" value="1246" />
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">الغرف</span>
                        <input class="edit-offer-page-input" name="rooms_count" type="text" placeholder="عدد الغرف" />
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">الواجهة</span>
                        <input class="offer-details-page-input" name="front" type="text" value="غربية" />
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">حالة العرض</span>
                        <select class="offer-details-page-input" name="offer_status">
                            <option>متاح</option>
                            <option>محجوز</option>
                            <option>مباع</option>
                        </select>
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">السعر</span>
                        <input class="offer-details-page-input" name="price" type="number" step="1" value="1500000" required />
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">الدور</span>
                        <input class="offer-details-page-input" name="floor" type="text" placeholder="مثال: أرضي / أول" />
                    </label>

                    <label class="offer-details-page-field">
                        <span class="offer-details-page-label">المساحة</span>
                        <input class="edit-offer-page-input" name="area" type="text" placeholder="150 متر" />
                    </label>

                </div>
                <br />

                <footer class="offer-details-page-modal__actions">
                    <button class="offer-details-page-btn" type="button" data-odp-close="true">إلغاء</button>
                    <button class="offer-details-page-btn offer-details-page-btn--primary" type="submit">حفظ التغييرات</button>
                </footer>
            </form>
        </div>
    </div>
    
    <?php if(isset($offer->details)): ?>
        <?php $__currentLoopData = $offer->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div id="offer-details-page-modal-<?php echo e($detail->id); ?>" class="offer-details-page-modal" role="dialog" hidden>
                <div class="offer-details-page-modal__backdrop" data-odp-close="true"></div>
                
                <div class="offer-details-page-modal__card" role="document">
                    <header class="offer-details-page-modal__head">
                        <h3 class="offer-details-page-modal__title">تعديل تفاصيل عقارية</h3>
                        <button class="offer-details-page-modal__close" type="button" aria-label="إغلاق" data-odp-close="true">×</button>
                    </header>

                    <form class="offer-details-page-modal__form" action="<?php echo e(route('admin/offers/update/details', $detail->id)); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="offer-details-page-modal__grid">
                            <label class="offer-details-page-field">
                                <span class="offer-details-page-label">رقم العرض</span>
                                <input class="offer-details-page-input" name="offer_number" value="<?php echo e($detail->offer_number); ?>" type="text" value="1246" />
                            </label>

                            <label class="offer-details-page-field">
                                <span class="offer-details-page-label">الغرف</span>
                                <input class="edit-offer-page-input" name="rooms_count" value="<?php echo e($detail->rooms_count); ?>" type="text" placeholder="عدد الغرف" />
                            </label>

                            <label class="offer-details-page-field">
                                <span class="offer-details-page-label">الواجهة</span>
                                <input class="offer-details-page-input" name="front" value="<?php echo e($detail->front); ?>" type="text" value="غربية" />
                            </label>

                            <label class="offer-details-page-field">
                                <span class="offer-details-page-label">حالة العرض</span>
                                <select class="offer-details-page-input" name="offer_status">
                                    <option value="متاح" <?php echo e($detail->offer_status == 'متاح' ? 'selected' : ''); ?>>متاح</option>
                                    <option value="محجوز" <?php echo e($detail->offer_status == 'محجوز' ? 'selected' : ''); ?>>محجوز</option>
                                    <option value="مباع" <?php echo e($detail->offer_status == 'مباع' ? 'selected' : ''); ?>>مباع</option>
                                </select>
                            </label>

                            <label class="offer-details-page-field">
                                <span class="offer-details-page-label">السعر</span>
                                <input class="offer-details-page-input" name="price" value="<?php echo e($detail->price); ?>" type="number" step="1" value="1500000" required />
                            </label>

                            <label class="offer-details-page-field">
                                <span class="offer-details-page-label">الدور</span>
                                <input class="offer-details-page-input" name="floor" value="<?php echo e($detail->floor); ?>" type="text" placeholder="مثال: أرضي / أول" />
                            </label>

                            <label class="offer-details-page-field">
                                <span class="offer-details-page-label">المساحة</span>
                                <input class="edit-offer-page-input" name="area" value="<?php echo e($detail->area); ?>" type="text" placeholder="150 متر" />
                            </label>

                        </div>
                        <footer class="offer-details-page-modal__actions">
                            <button type="button" class="offer-details-page-btn" data-odp-close="true">إلغاء</button>
                            <button type="submit" class="offer-details-page-btn offer-details-page-btn--primary">حفظ التغييرات</button>
                        </footer>
                    </form>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<!-- custom js -->
<?php $__env->startSection('script'); ?>
    <script>
        (function offersPageInit() {
            $("#pages").addClass('active');
            $("#offers-screen").addClass('is-active');
            document.getElementById('nav-group').setAttribute('open', '');
        })();
        $(document).ready(function() {

            $('.offer-details-page-chip').on('click', function() {
                $(`#${$(this).attr('target-model')}`).show();
            });
            $('#odp-add-unit').on('click', function() {
                $('#offer-details-page-modal').show();
            });

            $(document).on('click', '.offer-details-page-modal__close, .offer-details-page-btn[data-odp-close="true"]', function () {
                $(this).closest('.offer-details-page-modal').hide();
            });
            $(document).on('click', '.offer-details-page-modal__backdrop', function () {
                $(this).closest('.offer-details-page-modal').hide();
            });

            $('#odp-add-nearby').on('click', function() {
                let item = `
                    <div class="offer-details-page-textitem input-wrapper">
                        <input class="offer-details-page-input" name="nears_from[]" type="text" placeholder="مستشفى/مول/..." />
                        <button type="button" class="offer-details-page-remove">✕</button>
                    </div>
                `;
                $('#odp-nearby').append(item);
            });
            $('#odp-add-feature').on('click', function() {
                let item = `
                    <div class="offer-details-page-textitem input-wrapper">
                        <input class="offer-details-page-input" name="features[]" type="text" placeholder="ميزة جديدة..." />
                        <button type="button" class="offer-details-page-remove">✕</button>
                    </div>
                `;
                $('#odp-features').append(item);
            });
            var lenghtData = 1000000;
            $('#odp-add-amenity').on('click', function() {
                lenghtData++;
                let item = `
                    <div class="offer-details-page-textitem input-wrapper mb-2 d-flex">
                        <input class="offer-details-page-input" name="guarantees[${lenghtData}][years]" type="text" placeholder="years" />
                        <input class="offer-details-page-input" name="guarantees[${lenghtData}][content]" type="text" placeholder="content" />
                        <button type="button" class="offer-details-page-remove">✕</button>
                    </div>
                `;
                $('#odp-guarantees').append(item);
            });
            // $('#odp-add-media').on('click', function() {
            //     let item = `
            //         <label class="offer-details-page-uploader input-wrapper">
            //             <input class="offer-details-page-file" type="file" name="media[]" accept="image/*,video/*" />
            //             <div class="offer-details-page-uploader-ui">
            //                 <div class="offer-details-page-uploader-ico">⬆︎</div>
            //                 <div class="offer-details-page-uploader-text">ارفع الصورة/الفيديو أو اسحبه هنا</div>
            //                 <img class="offer-details-page-preview" alt="" hidden />
            //                 <video class="offer-details-page-video" controls hidden></video>
            //             </div>
            //             <button class="offer-details-page-remove" type="button" aria-label="حذف">✕</button>
            //         </label>
            //     `;
            //     $('#odp-media').append(item);
            // });
            $('#odp-add-media').on('click', function() {
                let item = `
                    <label class="offer-details-page-uploader input-wrapper">
                        <input class="offer-details-page-file" type="file" name="media[]" accept="image/*,video/*" />
                        <div class="offer-details-page-uploader-ui">
                            <div class="offer-details-page-uploader-ico">⬆︎</div>
                            <div class="offer-details-page-uploader-text">ارفع الصورة/الفيديو أو اسحبه هنا</div>
                            <img class="offer-details-page-preview" alt="" hidden />
                            <video class="offer-details-page-video" controls hidden></video>
                        </div>
                        <button class="offer-details-page-remove" type="button" aria-label="حذف">✕</button>
                    </label>
                `;

                let $item = $(item);
                $('#odp-media').append($item);

                $item.find('.offer-details-page-file').on('change', function(e) {
                    let file = this.files[0];
                    if (file) {
                        let reader = new FileReader();
                        reader.onload = function(evt) {
                            if (file.type.startsWith("image")) {
                                $item.find('.offer-details-page-preview').attr('src', evt.target.result).show();
                                $item.find('.offer-details-page-video').hide();
                            } else if (file.type.startsWith("video")) {
                                $item.find('.offer-details-page-video').attr('src', evt.target.result).show();
                                $item.find('.offer-details-page-preview').hide();
                            }
                        };
                        reader.readAsDataURL(file);
                    }
                });
                $item.find('.offer-details-page-remove').on('click', function() {
                    $item.remove();
                });
            });


        });
        $(document).on('click', '.offer-details-page-remove', function () {
            $(this).closest('.input-wrapper').remove();
        });
        $(document).on('click', '.delete-data-btn', function (e) {
            e.preventDefault();
            let form = $(this).closest('form');
            if (confirm("هل أنت متأكد أنك تريد حذف هذه البيانات ؟")) {
                form.submit();
            } else {
                return false;
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\htre-mvc\resources\views/admin/offers/details.blade.php ENDPATH**/ ?>