<!-- title page -->
<?php $__env->startSection('title'); ?>
    <title>Offers</title>
<?php $__env->stopSection(); ?>

<!-- custom css -->
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <section class="edit-offer-page" lang="ar" dir="rtl" aria-labelledby="edit-offer-page-title">
        <header class="edit-offer-page-head">
            <h2 id="edit-offer-page-title" class="edit-offer-page-title">تعديل عروض العقارية</h2>
        </header>

        <form id="edit-offer-page-form" class="edit-offer-page-form" role="form" action="<?php echo e(url(route('admin/offers/create'))); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php if($errors->any()): ?>
                <div style="text-align: left; margin: 15px;">
                    <ul dir="ltr">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="text-danger"><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <div class="edit-offer-page-grid">


                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">إضافة العنوان الرئيسي</span>
                    <input class="edit-offer-page-input" name="title" type="text" placeholder="فلل ريف – حي الازدهار" />
                </label>

                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">عدد الغرف</span>
                    <input class="edit-offer-page-input" name="rooms_count" type="text" placeholder="عدد الغرف" />
                </label>
                
                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">السعر</span>
                    <input class="edit-offer-page-input" name="price" type="number" step="0.01" value="2587249" />
                </label>

                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">عدد دورات المياه</span>
                    <input class="edit-offer-page-input" name="bathrooms_count" type="text" placeholder="عدد دورات المياه" />
                </label>

                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">المدينة</span>
                    <input class="edit-offer-page-input" name="city" type="text" placeholder="المدينة" />
                </label>
                
                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">المساحة</span>
                    <input class="edit-offer-page-input" name="area" type="text" placeholder="150 متر" />
                </label>
                
                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">مواقف السيارات</span>
                    <input class="edit-offer-page-input" name="parking_count" type="text" placeholder="مواقف السيارات" />
                </label>
                
                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">الواجهة</span>
                    <input class="edit-offer-page-input" name="facade" type="text" placeholder="الواجهة" />
                </label>

                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">حالة العقار</span>
                    <select class="edit-offer-page-input" name="status">
                        <option value="متاح">متاح</option>
                        <option value="محجوز">محجوز</option>
                        <option value="مباع">مباع</option>
                    </select>
                </label>
                
                
                <label class="edit-offer-page-field">
                    <span class="edit-offer-page-label">نوع العرض</span>
                    <select class="edit-offer-page-input" name="offer_type">
                        <option>مشاريع حصرية/عقارية</option>
                        <option value="1">مشاريع حصرية</option>
                        <option value="2">عروض عقارية</option>
                    </select>
                </label>

                <div class="edit-offer-page-field edit-offer-page-field--uploader">
                    <span class="edit-offer-page-label">الصورة الرئيسية</span>
                    <label class="edit-offer-page-uploader" data-edit-offer-dropzone>
                        <input class="edit-offer-page-file" type="file" accept="image/*" name="file" />
                        <div class="edit-offer-page-uploader-ui">
                            <div class="edit-offer-page-uploader-ico">⬆︎</div>
                            <div class="edit-offer-page-uploader-text">ارفع الصورة أو اسحبها هنا</div>
                            <img class="edit-offer-page-preview" hidden alt="" />
                        </div>
                    </label>
                </div>
            </div>

            <div class="edit-offer-page-actions">
                <button class="edit-offer-page-btn edit-offer-page-btn--primary" type="submit">حفظ التغييرات</button>
            </div>
        </form>
    </section>

<?php $__env->stopSection(); ?>

<!-- custom js -->
<?php $__env->startSection('script'); ?>
    <script>
        (function editOfferPageInit() {

            $("#pages").addClass('active');
            $("#offers-screen").addClass('is-active');
            document.getElementById('nav-group').setAttribute('open', '');

            const form = document.getElementById('edit-offer-page-form');
            const zone = form.querySelector('[data-edit-offer-dropzone]');
            const fileInput = form.querySelector('.edit-offer-page-file');
            const preview = form.querySelector('.edit-offer-page-preview');
            let imgDataUrl = '';

            // Uploader events
            zone.addEventListener('click', (e) => {
                if (e.target !== fileInput) fileInput.click();
            });
            fileInput.addEventListener('change', () => {
                const f = fileInput.files?.[0];
                if (f) showPreview(f);
            });
            ['dragenter', 'dragover'].forEach(ev => zone.addEventListener(ev, (e) => {
                e.preventDefault();
                zone.setAttribute('data-drop', '');
            }));
            ['dragleave', 'drop'].forEach(ev => zone.addEventListener(ev, (e) => {
                e.preventDefault();
                zone.removeAttribute('data-drop');
            }));
            zone.addEventListener('drop', (e) => {
                const f = e.dataTransfer?.files?.[0];
                if (f) {
                    fileInput.files = e.dataTransfer.files;
                    showPreview(f);
                }
            });

            function showPreview(file) {
                const reader = new FileReader();
                reader.onload = () => {
                    imgDataUrl = reader.result;
                    preview.src = imgDataUrl;
                    preview.hidden = false;
                };
                reader.readAsDataURL(file);
            }

            // Submit
            // form.addEventListener('submit', (e) => {
            //     e.preventDefault();
            //     const data = Object.fromEntries(new FormData(form).entries());
            //     data.image = imgDataUrl;
            //     console.log('Form Data:', data);
            //     alert('تم حفظ التغييرات (ديمو)');
            // });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\htre-mvc\resources\views/admin/offers/create.blade.php ENDPATH**/ ?>