<!-- title page -->
<?php $__env->startSection('title'); ?>
    <title>Offers</title>
<?php $__env->stopSection(); ?>

<!-- custom css -->
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="offers-page" lang="ar" dir="rtl" aria-labelledby="offers-page-title">
        <header class="offers-page-topbar">
            <h2 id="offers-page-title" class="offers-page-title">العروض العقارية</h2>
        </header>
        <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if($errors->any()): ?>
            <div style="text-align: left; margin: 15px;">
                <ul dir="ltr">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="text-danger"><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <header class="offers-page-topbar" dir="ltr">
            <button id="" class="offers-page-btn offers-page-btn--primary" type="button">
                <a href="<?php echo e(route('admin/offers/create')); ?>" class="custom-link" style="color: white;">إضافة عقار</a>
            </button>
        </header>

        <!-- الجدول -->
        <div class="offers-page-table" role="table" aria-label="جدول العروض">
            <div class="offers-page-thead" role="rowgroup">
                <div class="offers-page-row offers-page-row--head" role="row">
                    <div class="offers-page-col offers-page-col--image" role="columnheader">الصورة</div>
                    <div class="offers-page-col" role="columnheader">اسم الوحدة</div>
                    <div class="offers-page-col offers-page-col--price" role="columnheader">السعر</div>
                    <div class="offers-page-col offers-page-col--actions" role="columnheader" aria-label="إجراءات">إجراءات</div>
                </div>
            </div>

            <div id="offers-page-tbody" class="offers-page-tbody" role="rowgroup">
                
                <?php if(isset($offers)): ?>
                    <?php $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="offers-page-row" role="row" data-offers-page-item>
                            <div class="offers-page-col offers-page-col--image" role="cell">
                                <img class="offers-page-thumb" src="<?php echo e(asset($offer->img)); ?>" alt="صورة العقار" />
                            </div>
                            <div class="offers-page-col" role="cell">
                                <div class="offers-page-unit"><?php echo e($offer->title); ?></div>
                                <div class="offers-page-meta"></div>
                            </div>
                            <div class="offers-page-col offers-page-col--price" role="cell">
                                <b class="offers-page-price"><?php echo e($offer->price); ?></b>
                            </div>
                            <div class="offers-page-col offers-page-col--actions" role="cell">
                                <button class="offers-page-chip offers-page-chip--ghost" data-action="details" type="button">
                                    <a href="<?php echo e(url(route('admin/offers/details', $offer->id))); ?>" class="custom-link">
                                        تفاصيل العقار
                                    <a>
                                </button>
                                <button class="offers-page-chip offers-page-chip--edit" data-action="edit" type="button">
                                    <a href="<?php echo e(route('admin/offers/edit', $offer->id)); ?>" class="custom-link">
                                        تعديل
                                    </a>
                                </button>
                                
                                
                                <form action="<?php echo e(url(route('admin/offers/delete/custom', $offer->id))); ?>" method="get">
                                    <?php echo csrf_field(); ?>
                                    <button class="offers-page-chip offers-page-chip--danger delete-data-btn" type="submit">
                                        <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> حذف
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>

    </section>
<?php $__env->stopSection(); ?>

<!-- custom js -->
<?php $__env->startSection('script'); ?>
    <script>
        (function offersPageInit() {

            $("#pages").addClass('active');
            $("#offers-screen").addClass('is-active');
            document.getElementById('nav-group').setAttribute('open', '');

            $(document).on('click', '.delete-data-btn', function (e) {
                e.preventDefault();
                let form = $(this).closest('form');
                if (confirm("هل أنت متأكد أنك تريد حذف هذه البيانات ؟")) {
                    form.submit();
                } else {
                    return false;
                }
            });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\htre-mvc\resources\views/admin/offers/index.blade.php ENDPATH**/ ?>