<!-- title page -->
<?php $__env->startSection('title'); ?>
    <title>DashBoard</title>
<?php $__env->stopSection(); ?>

<!-- custom page -->
<?php $__env->startSection('css'); ?>
<style>
.pagination {
    list-style: none;
    display: flex;
    gap: 5px;
}
.page-item {
    list-style: none;
}
.page-link {
    text-decoration: none;
}
.custom-page-link {
    border-radius: 6px;
    padding: 0px 6px;
    border: 2px solid darkgray;
}
.custom-color-page-link {
    background: darkgray;
}
.requests-page-row{
  display:grid;
  grid-template-columns: repeat(9, minmax(120px,1fr));
  gap: 12px;
}
.requests-page-col{ min-width:0; }
.requests-page-row--head .requests-page-col{
  white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
}


.requests-page-row{
    display: grid;
    grid-template-columns: 1.2fr 1.4fr 0.9fr 2.2fr; 
    gap: 0; 
}
.requests-page-col{
    min-width: 0;                
    padding: .75rem 1rem;
    border-bottom: 1px solid #eee;
    align-self: center;
}
.requests-page-row--head{
    background: #f8fafc;
    font-weight: 700;
    position: sticky;  
    top: 0;
    z-index: 1;
    border-bottom: 1px solid #e5e7eb;
}
.requests-page-tbody .requests-page-col{
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}
.requests-page-tbody .requests-page-row > .requests-page-col:nth-child(4){
    white-space: normal;
    overflow: hidden;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    word-break: break-word;
}
.pagination{ list-style:none; display:flex; gap:6px; }
.page-item{ list-style:none; }
.page-link{ text-decoration:none; border:1px solid #ddd; padding:.25rem .55rem; border-radius:6px; }
.page-item.active .page-link,
.custom-color-page-link{ background:#ddd; }

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="requests-page" lang="ar" dir="rtl" aria-labelledby="requests-page-title">
        <header class="requests-page-topbar">
            <h2 id="requests-page-title" class="requests-page-title">طلبات المسجّلة</h2>
            <div class="requests-page-tools">
                <input id="requests-page-search" class="requests-page-search" type="search" placeholder="ابحث بالاسم، المدينة، الجوال…" />
            </div>
        </header>

        <div class="requests-page-table" role="table" aria-label="طلبات المسجّلة">
            <div class="requests-page-row requests-page-row--head" role="row">
                <div class="requests-page-col" role="columnheader">الاسم بالكامل</div>
                <div class="requests-page-col" role="columnheader">الايميل</div>
                <div class="requests-page-col" role="columnheader">رقم الجوال</div>
                <div class="requests-page-col" role="columnheader">الرساله</div>
            </div>

            <div id="requests-page-tbody" class="requests-page-tbody" role="rowgroup">
                <?php if(isset($contacts)): ?>
                    <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="requests-page-row" role="row">
                            <div class="requests-page-col" role="cell"><?php echo e($record->name); ?></div>
                            <div class="requests-page-col" role="cell"><?php echo e($record->email); ?></div>
                            <div class="requests-page-col" role="cell"><?php echo e($record->mobile); ?></div>
                            <div class="requests-page-col" role="cell"><?php echo e($record->message); ?></div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div id="requests-page-empty" class="requests-page-empty">لا توجد نتائج مطابقة.</div>
                <?php endif; ?>
            </div>

            <div class="d-flex justify-content-center mt-2">
                <div class="d-flex justify-content-center mt-2">
                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <!-- Previous Button -->
                            <?php if(!$contacts->onFirstPage()): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?php echo e($contacts->previousPageUrl()); ?>" aria-label="Previous">
                                        <span aria-hidden="true">&laquo;</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <!-- Pagination Numbers -->
                            <?php for($i = 1; $i <= $contacts->lastPage(); $i++): ?>
                                <li class="page-item <?php echo e($i == $contacts->currentPage() ? 'active' : ''); ?>">
                                    <a class="page-link custom-page-link <?php echo e(request()->get('page') == $i ? 'custom-color-page-link' : ''); ?>" href="<?php echo e($contacts->url($i)); ?>">
                                        <?php echo e($i); ?>

                                    </a>
                                </li>
                            <?php endfor; ?>

                            <!-- Next Button -->
                            <?php if($contacts->hasMorePages()): ?>
                                <li class="page-item">
                                    <a class="page-link <?php echo e(request()->get('page') == $i ? 'custom-color-page-link' : ''); ?>" href="<?php echo e($contacts->nextPageUrl()); ?>" aria-label="Next">
                                        <span aria-hidden="true">&raquo;</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<!-- custom js -->
<?php $__env->startSection('script'); ?>
    <script>
        (function() {

            $("#pages").addClass('active');
            $("#contacts-screen").addClass('is-active');
            document.getElementById('nav-group').setAttribute('open', '');

            function previewSingle(input) {
                const file = input.files && input.files[0];
                const box = input.closest('label')
                if (!file || !box) return;
                let img = box.querySelector('.upload__img');
                if (!img) {
                    img = document.createElement('img');
                    img.className = 'upload__img';
                    box.appendChild(img);
                }
                img.src = URL.createObjectURL(file);
                box.classList.add('has-image');
            }

            function previewPartner(input) {
                const file = input.files && input.files[0];
                if (!file) return;

                const container = input.closest('.input-container, .home-form__partner, .services-page__card, label');
                if (!container) return;

                let img = container.querySelector('.partner__img');
                if (!img) {
                    img = document.createElement('img');
                    img.className = 'partner__img';

                    const label = input.closest('label') || container;
                    label.appendChild(img);
                }
                img.src = URL.createObjectURL(file);

                const label = input.closest('label');
                if (label) label.classList.add('has-image');
            }

            document.addEventListener('change', function(e) {
                const t = e.target;
                if (!(t instanceof HTMLInputElement)) return;
                if (t.type !== 'file') return;

                const isRatingImg = t.matches('[name^="values["][name$="[img]"]');

                if (t.name === 'base_img' || t.name === 'statistic_img' || isRatingImg) {
                    return previewSingle(t);
                }

                if (t.name === 'partner_logos[]') {
                    return previewPartner(t);
                }
            });

            document.addEventListener('click', function(e) {
                const btn = e.target.closest('.remove-btn');
                if (!btn) return;
                e.preventDefault();

                const wrap = btn.closest('.input-container, .home-form__partner, .services-page__card');
                if (!wrap) return;

                const fileInput = wrap.querySelector('input[type="file"]');
                const img = wrap.querySelector('.partner__img, .upload__img');
                if (fileInput) fileInput.value = '';
                if (img) img.remove();
                const label = wrap.querySelector('label');
                if (label) label.classList.remove('has-image');

            });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\htre-mvc\resources\views/admin/pages/contacts.blade.php ENDPATH**/ ?>